/* Copyright (c) 2014, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#ifndef WCD9330_REGISTERS_H
#define WCD9330_REGISTERS_H

#include <linux/types.h>

#define TOMTOM_A_CHIP_CTL			(0x000)
#define TOMTOM_A_CHIP_CTL__POR				(0x38)
#define TOMTOM_A_CHIP_STATUS			(0x001)
#define TOMTOM_A_CHIP_STATUS__POR				(0x00)
#define TOMTOM_A_CHIP_ID_BYTE_0			(0x004)
#define TOMTOM_A_CHIP_ID_BYTE_0__POR				(0x00)
#define TOMTOM_A_CHIP_ID_BYTE_1			(0x005)
#define TOMTOM_A_CHIP_ID_BYTE_1__POR				(0x00)
#define TOMTOM_A_CHIP_ID_BYTE_2			(0x006)
#define TOMTOM_A_CHIP_ID_BYTE_2__POR				(0x05)
#define TOMTOM_A_CHIP_ID_BYTE_3			(0x007)
#define TOMTOM_A_CHIP_ID_BYTE_3__POR				(0x01)
#define TOMTOM_A_CHIP_I2C_SLAVE_ID			(0x008)
#define TOMTOM_A_CHIP_I2C_SLAVE_ID__POR				(0x01)
#define TOMTOM_A_SLAVE_ID_1			(0x00C)
#define TOMTOM_A_SLAVE_ID_1__POR				(0x77)
#define TOMTOM_A_SLAVE_ID_2			(0x00D)
#define TOMTOM_A_SLAVE_ID_2__POR				(0x66)
#define TOMTOM_A_SLAVE_ID_3			(0x00E)
#define TOMTOM_A_SLAVE_ID_3__POR				(0x55)
#define TOMTOM_A_PIN_CTL_OE0			(0x010)
#define TOMTOM_A_PIN_CTL_OE0__POR				(0x00)
#define TOMTOM_A_PIN_CTL_OE1			(0x011)
#define TOMTOM_A_PIN_CTL_OE1__POR				(0x00)
#define TOMTOM_A_PIN_CTL_OE2			(0x012)
#define TOMTOM_A_PIN_CTL_OE2__POR				(0x00)
#define TOMTOM_A_PIN_CTL_DATA0			(0x013)
#define TOMTOM_A_PIN_CTL_DATA0__POR				(0x00)
#define TOMTOM_A_PIN_CTL_DATA1			(0x014)
#define TOMTOM_A_PIN_CTL_DATA1__POR				(0x00)
#define TOMTOM_A_PIN_CTL_DATA2			(0x015)
#define TOMTOM_A_PIN_CTL_DATA2__POR				(0x00)
#define TOMTOM_A_HDRIVE_GENERIC			(0x018)
#define TOMTOM_A_HDRIVE_GENERIC__POR				(0x00)
#define TOMTOM_A_HDRIVE_OVERRIDE			(0x019)
#define TOMTOM_A_HDRIVE_OVERRIDE__POR				(0x08)
#define TOMTOM_A_ANA_CSR_WAIT_STATE			(0x01C)
#define TOMTOM_A_ANA_CSR_WAIT_STATE__POR				(0x44)
#define TOMTOM_A_PROCESS_MONITOR_CTL0			(0x020)
#define TOMTOM_A_PROCESS_MONITOR_CTL0__POR				(0x80)
#define TOMTOM_A_PROCESS_MONITOR_CTL1			(0x021)
#define TOMTOM_A_PROCESS_MONITOR_CTL1__POR				(0x00)
#define TOMTOM_A_PROCESS_MONITOR_CTL2			(0x022)
#define TOMTOM_A_PROCESS_MONITOR_CTL2__POR				(0x00)
#define TOMTOM_A_PROCESS_MONITOR_CTL3			(0x023)
#define TOMTOM_A_PROCESS_MONITOR_CTL3__POR				(0x01)
#define TOMTOM_A_QFUSE_CTL			(0x028)
#define TOMTOM_A_QFUSE_CTL__POR				(0x00)
#define TOMTOM_A_QFUSE_STATUS			(0x029)
#define TOMTOM_A_QFUSE_STATUS__POR				(0x00)
#define TOMTOM_A_QFUSE_DATA_OUT0			(0x02A)
#define TOMTOM_A_QFUSE_DATA_OUT0__POR				(0x00)
#define TOMTOM_A_QFUSE_DATA_OUT1			(0x02B)
#define TOMTOM_A_QFUSE_DATA_OUT1__POR				(0x00)
#define TOMTOM_A_QFUSE_DATA_OUT2			(0x02C)
#define TOMTOM_A_QFUSE_DATA_OUT2__POR				(0x00)
#define TOMTOM_A_QFUSE_DATA_OUT3			(0x02D)
#define TOMTOM_A_QFUSE_DATA_OUT3__POR				(0x00)
#define TOMTOM_A_QFUSE_DATA_OUT4			(0x02E)
#define TOMTOM_A_QFUSE_DATA_OUT4__POR				(0x00)
#define TOMTOM_A_QFUSE_DATA_OUT5			(0x02F)
#define TOMTOM_A_QFUSE_DATA_OUT5__POR				(0x00)
#define TOMTOM_A_QFUSE_DATA_OUT6			(0x030)
#define TOMTOM_A_QFUSE_DATA_OUT6__POR				(0x00)
#define TOMTOM_A_QFUSE_DATA_OUT7			(0x031)
#define TOMTOM_A_QFUSE_DATA_OUT7__POR				(0x00)
#define TOMTOM_A_CDC_CTL			(0x034)
#define TOMTOM_A_CDC_CTL__POR				(0x00)
#define TOMTOM_A_LEAKAGE_CTL			(0x03C)
#define TOMTOM_A_LEAKAGE_CTL__POR				(0x04)
#define TOMTOM_A_SVASS_MEM_PTR0			(0x044)
#define TOMTOM_A_SVASS_MEM_PTR0__POR				(0x00)
#define TOMTOM_A_SVASS_MEM_PTR1			(0x045)
#define TOMTOM_A_SVASS_MEM_PTR1__POR				(0x00)
#define TOMTOM_A_SVASS_MEM_PTR2			(0x046)
#define TOMTOM_A_SVASS_MEM_PTR2__POR				(0x00)
#define TOMTOM_A_SVASS_MEM_CTL			(0x048)
#define TOMTOM_A_SVASS_MEM_CTL__POR				(0x04)
#define TOMTOM_A_SVASS_MEM_BANK			(0x049)
#define TOMTOM_A_SVASS_MEM_BANK__POR				(0x00)
#define TOMTOM_A_DMIC_B1_CTL			(0x04A)
#define TOMTOM_A_DMIC_B1_CTL__POR				(0x00)
#define TOMTOM_A_DMIC_B2_CTL			(0x04B)
#define TOMTOM_A_DMIC_B2_CTL__POR				(0x00)
#define TOMTOM_A_SVASS_CLKRST_CTL			(0x04C)
#define TOMTOM_A_SVASS_CLKRST_CTL__POR				(0x00)
#define TOMTOM_A_SVASS_CPAR_CFG			(0x04D)
#define TOMTOM_A_SVASS_CPAR_CFG__POR				(0x00)
#define TOMTOM_A_SVASS_BUF_RDY_INT_PERIOD			(0x04E)
#define TOMTOM_A_SVASS_BUF_RDY_INT_PERIOD__POR				(0x14)
#define TOMTOM_A_SVASS_CPAR_WDOG_CFG			(0x04F)
#define TOMTOM_A_SVASS_CPAR_WDOG_CFG__POR				(0x00)
#define TOMTOM_A_SVASS_CFG			(0x050)
#define TOMTOM_A_SVASS_CFG__POR				(0x01)
#define TOMTOM_A_SVASS_SPE_CFG			(0x051)
#define TOMTOM_A_SVASS_SPE_CFG__POR				(0x04)
#define TOMTOM_A_SVASS_STATUS			(0x052)
#define TOMTOM_A_SVASS_STATUS__POR				(0x00)
#define TOMTOM_A_SVASS_INT_MASK			(0x053)
#define TOMTOM_A_SVASS_INT_MASK__POR				(0x3F)
#define TOMTOM_A_SVASS_INT_STATUS			(0x054)
#define TOMTOM_A_SVASS_INT_STATUS__POR				(0x00)
#define TOMTOM_A_SVASS_INT_CLR			(0x055)
#define TOMTOM_A_SVASS_INT_CLR__POR				(0x00)
#define TOMTOM_A_SVASS_DEBUG			(0x056)
#define TOMTOM_A_SVASS_DEBUG__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_BKUP_INT			(0x057)
#define TOMTOM_A_SVASS_SPE_BKUP_INT__POR				(0x00)
#define TOMTOM_A_SVASS_MEM_ACC			(0x058)
#define TOMTOM_A_SVASS_MEM_ACC__POR				(0x00)
#define TOMTOM_A_MEM_LEAKAGE_CTL			(0x059)
#define TOMTOM_A_MEM_LEAKAGE_CTL__POR				(0x04)
#define TOMTOM_A_SVASS_SPE_INBOX_TRG			(0x05A)
#define TOMTOM_A_SVASS_SPE_INBOX_TRG__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_INBOX_0			(0x060)
#define TOMTOM_A_SVASS_SPE_INBOX_0__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_INBOX_1			(0x061)
#define TOMTOM_A_SVASS_SPE_INBOX_1__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_INBOX_2			(0x062)
#define TOMTOM_A_SVASS_SPE_INBOX_2__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_INBOX_3			(0x063)
#define TOMTOM_A_SVASS_SPE_INBOX_3__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_INBOX_4			(0x064)
#define TOMTOM_A_SVASS_SPE_INBOX_4__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_INBOX_5			(0x065)
#define TOMTOM_A_SVASS_SPE_INBOX_5__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_INBOX_6			(0x066)
#define TOMTOM_A_SVASS_SPE_INBOX_6__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_INBOX_7			(0x067)
#define TOMTOM_A_SVASS_SPE_INBOX_7__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_INBOX_8			(0x068)
#define TOMTOM_A_SVASS_SPE_INBOX_8__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_INBOX_9			(0x069)
#define TOMTOM_A_SVASS_SPE_INBOX_9__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_INBOX_10			(0x06A)
#define TOMTOM_A_SVASS_SPE_INBOX_10__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_INBOX_11			(0x06B)
#define TOMTOM_A_SVASS_SPE_INBOX_11__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_OUTBOX_0			(0x070)
#define TOMTOM_A_SVASS_SPE_OUTBOX_0__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_OUTBOX_1			(0x071)
#define TOMTOM_A_SVASS_SPE_OUTBOX_1__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_OUTBOX_2			(0x072)
#define TOMTOM_A_SVASS_SPE_OUTBOX_2__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_OUTBOX_3			(0x073)
#define TOMTOM_A_SVASS_SPE_OUTBOX_3__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_OUTBOX_4			(0x074)
#define TOMTOM_A_SVASS_SPE_OUTBOX_4__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_OUTBOX_5			(0x075)
#define TOMTOM_A_SVASS_SPE_OUTBOX_5__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_OUTBOX_6			(0x076)
#define TOMTOM_A_SVASS_SPE_OUTBOX_6__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_OUTBOX_7			(0x077)
#define TOMTOM_A_SVASS_SPE_OUTBOX_7__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_OUTBOX_8			(0x078)
#define TOMTOM_A_SVASS_SPE_OUTBOX_8__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_OUTBOX_9			(0x079)
#define TOMTOM_A_SVASS_SPE_OUTBOX_9__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_OUTBOX_10			(0x07A)
#define TOMTOM_A_SVASS_SPE_OUTBOX_10__POR				(0x00)
#define TOMTOM_A_SVASS_SPE_OUTBOX_11			(0x07B)
#define TOMTOM_A_SVASS_SPE_OUTBOX_11__POR				(0x00)
#define TOMTOM_A_INTR_MODE			(0x090)
#define TOMTOM_A_INTR_MODE__POR				(0x00)
#define TOMTOM_A_INTR1_MASK0			(0x094)
#define TOMTOM_A_INTR1_MASK0__POR				(0xFF)
#define TOMTOM_A_INTR1_MASK1			(0x095)
#define TOMTOM_A_INTR1_MASK1__POR				(0xFF)
#define TOMTOM_A_INTR1_MASK2			(0x096)
#define TOMTOM_A_INTR1_MASK2__POR				(0xFF)
#define TOMTOM_A_INTR1_MASK3			(0x097)
#define TOMTOM_A_INTR1_MASK3__POR				(0xFF)
#define TOMTOM_A_INTR1_STATUS0			(0x098)
#define TOMTOM_A_INTR1_STATUS0__POR				(0x00)
#define TOMTOM_A_INTR1_STATUS1			(0x099)
#define TOMTOM_A_INTR1_STATUS1__POR				(0x00)
#define TOMTOM_A_INTR1_STATUS2			(0x09A)
#define TOMTOM_A_INTR1_STATUS2__POR				(0x00)
#define TOMTOM_A_INTR1_STATUS3			(0x09B)
#define TOMTOM_A_INTR1_STATUS3__POR				(0x00)
#define TOMTOM_A_INTR1_CLEAR0			(0x09C)
#define TOMTOM_A_INTR1_CLEAR0__POR				(0x00)
#define TOMTOM_A_INTR1_CLEAR1			(0x09D)
#define TOMTOM_A_INTR1_CLEAR1__POR				(0x00)
#define TOMTOM_A_INTR1_CLEAR2			(0x09E)
#define TOMTOM_A_INTR1_CLEAR2__POR				(0x00)
#define TOMTOM_A_INTR1_CLEAR3			(0x09F)
#define TOMTOM_A_INTR1_CLEAR3__POR				(0x00)
#define TOMTOM_A_INTR1_LEVEL0			(0x0A0)
#define TOMTOM_A_INTR1_LEVEL0__POR				(0x01)
#define TOMTOM_A_INTR1_LEVEL1			(0x0A1)
#define TOMTOM_A_INTR1_LEVEL1__POR				(0x00)
#define TOMTOM_A_INTR1_LEVEL2			(0x0A2)
#define TOMTOM_A_INTR1_LEVEL2__POR				(0x40)
#define TOMTOM_A_INTR1_LEVEL3			(0x0A3)
#define TOMTOM_A_INTR1_LEVEL3__POR				(0x00)
#define TOMTOM_A_INTR1_TEST0			(0x0A4)
#define TOMTOM_A_INTR1_TEST0__POR				(0x00)
#define TOMTOM_A_INTR1_TEST1			(0x0A5)
#define TOMTOM_A_INTR1_TEST1__POR				(0x00)
#define TOMTOM_A_INTR1_TEST2			(0x0A6)
#define TOMTOM_A_INTR1_TEST2__POR				(0x00)
#define TOMTOM_A_INTR1_TEST3			(0x0A7)
#define TOMTOM_A_INTR1_TEST3__POR				(0x00)
#define TOMTOM_A_INTR1_SET0			(0x0A8)
#define TOMTOM_A_INTR1_SET0__POR				(0x00)
#define TOMTOM_A_INTR1_SET1			(0x0A9)
#define TOMTOM_A_INTR1_SET1__POR				(0x00)
#define TOMTOM_A_INTR1_SET2			(0x0AA)
#define TOMTOM_A_INTR1_SET2__POR				(0x00)
#define TOMTOM_A_INTR1_SET3			(0x0AB)
#define TOMTOM_A_INTR1_SET3__POR				(0x00)
#define TOMTOM_A_INTR2_MASK0			(0x0B0)
#define TOMTOM_A_INTR2_MASK0__POR				(0xFF)
#define TOMTOM_A_INTR2_STATUS0			(0x0B2)
#define TOMTOM_A_INTR2_STATUS0__POR				(0x00)
#define TOMTOM_A_INTR2_CLEAR0			(0x0B4)
#define TOMTOM_A_INTR2_CLEAR0__POR				(0x00)
#define TOMTOM_A_INTR2_LEVEL0			(0x0B6)
#define TOMTOM_A_INTR2_LEVEL0__POR				(0x00)
#define TOMTOM_A_INTR2_TEST0			(0x0B8)
#define TOMTOM_A_INTR2_TEST0__POR				(0x00)
#define TOMTOM_A_INTR2_SET0			(0x0BA)
#define TOMTOM_A_INTR2_SET0__POR				(0x00)
#define TOMTOM_A_CDC_TX_I2S_SCK_MODE			(0x0C0)
#define TOMTOM_A_CDC_TX_I2S_SCK_MODE__POR				(0x00)
#define TOMTOM_A_CDC_TX_I2S_WS_MODE			(0x0C1)
#define TOMTOM_A_CDC_TX_I2S_WS_MODE__POR				(0x00)
#define TOMTOM_A_CDC_DMIC_DATA0_MODE			(0x0C4)
#define TOMTOM_A_CDC_DMIC_DATA0_MODE__POR				(0x00)
#define TOMTOM_A_CDC_DMIC_CLK0_MODE			(0x0C5)
#define TOMTOM_A_CDC_DMIC_CLK0_MODE__POR				(0x00)
#define TOMTOM_A_CDC_DMIC_DATA1_MODE			(0x0C6)
#define TOMTOM_A_CDC_DMIC_DATA1_MODE__POR				(0x00)
#define TOMTOM_A_CDC_DMIC_CLK1_MODE			(0x0C7)
#define TOMTOM_A_CDC_DMIC_CLK1_MODE__POR				(0x00)
#define TOMTOM_A_CDC_RX_I2S_SCK_MODE			(0x0C8)
#define TOMTOM_A_CDC_RX_I2S_SCK_MODE__POR				(0x00)
#define TOMTOM_A_CDC_RX_I2S_WS_MODE			(0x0C9)
#define TOMTOM_A_CDC_RX_I2S_WS_MODE__POR				(0x00)
#define TOMTOM_A_CDC_DMIC_DATA2_MODE			(0x0CA)
#define TOMTOM_A_CDC_DMIC_DATA2_MODE__POR				(0x00)
#define TOMTOM_A_CDC_DMIC_CLK2_MODE			(0x0CB)
#define TOMTOM_A_CDC_DMIC_CLK2_MODE__POR				(0x00)
#define TOMTOM_A_CDC_INTR1_MODE			(0x0CC)
#define TOMTOM_A_CDC_INTR1_MODE__POR				(0x00)
#define TOMTOM_A_CDC_SB_NRZ_SEL_MODE			(0x0CD)
#define TOMTOM_A_CDC_SB_NRZ_SEL_MODE__POR				(0x00)
#define TOMTOM_A_CDC_INTR2_MODE			(0x0CE)
#define TOMTOM_A_CDC_INTR2_MODE__POR				(0x00)
#define TOMTOM_A_CDC_RF_PA_ON_MODE			(0x0CF)
#define TOMTOM_A_CDC_RF_PA_ON_MODE__POR				(0x00)
#define TOMTOM_A_CDC_BOOST_MODE			(0x0D0)
#define TOMTOM_A_CDC_BOOST_MODE__POR				(0x00)
#define TOMTOM_A_CDC_JTCK_MODE			(0x0D1)
#define TOMTOM_A_CDC_JTCK_MODE__POR				(0x00)
#define TOMTOM_A_CDC_JTDI_MODE			(0x0D2)
#define TOMTOM_A_CDC_JTDI_MODE__POR				(0x00)
#define TOMTOM_A_CDC_JTMS_MODE			(0x0D3)
#define TOMTOM_A_CDC_JTMS_MODE__POR				(0x00)
#define TOMTOM_A_CDC_JTDO_MODE			(0x0D4)
#define TOMTOM_A_CDC_JTDO_MODE__POR				(0x00)
#define TOMTOM_A_CDC_JTRST_MODE			(0x0D5)
#define TOMTOM_A_CDC_JTRST_MODE__POR				(0x00)
#define TOMTOM_A_CDC_BIST_MODE_MODE			(0x0D6)
#define TOMTOM_A_CDC_BIST_MODE_MODE__POR				(0x00)
#define TOMTOM_A_CDC_MAD_MAIN_CTL_1			(0x0E0)
#define TOMTOM_A_CDC_MAD_MAIN_CTL_1__POR				(0x00)
#define TOMTOM_A_CDC_MAD_MAIN_CTL_2			(0x0E1)
#define TOMTOM_A_CDC_MAD_MAIN_CTL_2__POR				(0x00)
#define TOMTOM_A_CDC_MAD_AUDIO_CTL_1			(0x0E2)
#define TOMTOM_A_CDC_MAD_AUDIO_CTL_1__POR				(0x00)
#define TOMTOM_A_CDC_MAD_AUDIO_CTL_2			(0x0E3)
#define TOMTOM_A_CDC_MAD_AUDIO_CTL_2__POR				(0x00)
#define TOMTOM_A_CDC_MAD_AUDIO_CTL_3			(0x0E4)
#define TOMTOM_A_CDC_MAD_AUDIO_CTL_3__POR				(0x00)
#define TOMTOM_A_CDC_MAD_AUDIO_CTL_4			(0x0E5)
#define TOMTOM_A_CDC_MAD_AUDIO_CTL_4__POR				(0x00)
#define TOMTOM_A_CDC_MAD_AUDIO_CTL_5			(0x0E6)
#define TOMTOM_A_CDC_MAD_AUDIO_CTL_5__POR				(0x00)
#define TOMTOM_A_CDC_MAD_AUDIO_CTL_6			(0x0E7)
#define TOMTOM_A_CDC_MAD_AUDIO_CTL_6__POR				(0x00)
#define TOMTOM_A_CDC_MAD_AUDIO_CTL_7			(0x0E8)
#define TOMTOM_A_CDC_MAD_AUDIO_CTL_7__POR				(0x00)
#define TOMTOM_A_CDC_MAD_AUDIO_CTL_8			(0x0E9)
#define TOMTOM_A_CDC_MAD_AUDIO_CTL_8__POR				(0x00)
#define TOMTOM_A_CDC_MAD_AUDIO_IIR_CTL_PTR			(0x0EA)
#define TOMTOM_A_CDC_MAD_AUDIO_IIR_CTL_PTR__POR				(0x00)
#define TOMTOM_A_CDC_MAD_AUDIO_IIR_CTL_VAL			(0x0EB)
#define TOMTOM_A_CDC_MAD_AUDIO_IIR_CTL_VAL__POR				(0x40)
#define TOMTOM_A_CDC_MAD_ULTR_CTL_1			(0x0EC)
#define TOMTOM_A_CDC_MAD_ULTR_CTL_1__POR				(0x00)
#define TOMTOM_A_CDC_MAD_ULTR_CTL_2			(0x0ED)
#define TOMTOM_A_CDC_MAD_ULTR_CTL_2__POR				(0x00)
#define TOMTOM_A_CDC_MAD_ULTR_CTL_3			(0x0EE)
#define TOMTOM_A_CDC_MAD_ULTR_CTL_3__POR				(0x00)
#define TOMTOM_A_CDC_MAD_ULTR_CTL_4			(0x0EF)
#define TOMTOM_A_CDC_MAD_ULTR_CTL_4__POR				(0x00)
#define TOMTOM_A_CDC_MAD_ULTR_CTL_5			(0x0F0)
#define TOMTOM_A_CDC_MAD_ULTR_CTL_5__POR				(0x00)
#define TOMTOM_A_CDC_MAD_ULTR_CTL_6			(0x0F1)
#define TOMTOM_A_CDC_MAD_ULTR_CTL_6__POR				(0x00)
#define TOMTOM_A_CDC_MAD_ULTR_CTL_7			(0x0F2)
#define TOMTOM_A_CDC_MAD_ULTR_CTL_7__POR				(0x00)
#define TOMTOM_A_CDC_MAD_BEACON_CTL_1			(0x0F3)
#define TOMTOM_A_CDC_MAD_BEACON_CTL_1__POR				(0x00)
#define TOMTOM_A_CDC_MAD_BEACON_CTL_2			(0x0F4)
#define TOMTOM_A_CDC_MAD_BEACON_CTL_2__POR				(0x00)
#define TOMTOM_A_CDC_MAD_BEACON_CTL_3			(0x0F5)
#define TOMTOM_A_CDC_MAD_BEACON_CTL_3__POR				(0x00)
#define TOMTOM_A_CDC_MAD_BEACON_CTL_4			(0x0F6)
#define TOMTOM_A_CDC_MAD_BEACON_CTL_4__POR				(0x00)
#define TOMTOM_A_CDC_MAD_BEACON_CTL_5			(0x0F7)
#define TOMTOM_A_CDC_MAD_BEACON_CTL_5__POR				(0x00)
#define TOMTOM_A_CDC_MAD_BEACON_CTL_6			(0x0F8)
#define TOMTOM_A_CDC_MAD_BEACON_CTL_6__POR				(0x00)
#define TOMTOM_A_CDC_MAD_BEACON_CTL_7			(0x0F9)
#define TOMTOM_A_CDC_MAD_BEACON_CTL_7__POR				(0x00)
#define TOMTOM_A_CDC_MAD_BEACON_CTL_8			(0x0FA)
#define TOMTOM_A_CDC_MAD_BEACON_CTL_8__POR				(0x00)
#define TOMTOM_A_CDC_MAD_BEACON_IIR_CTL_PTR			(0x0FB)
#define TOMTOM_A_CDC_MAD_BEACON_IIR_CTL_PTR__POR			(0x00)
#define TOMTOM_A_CDC_MAD_BEACON_IIR_CTL_VAL			(0x0FC)
#define TOMTOM_A_CDC_MAD_BEACON_IIR_CTL_VAL__POR			(0x00)
#define TOMTOM_A_CDC_MAD_INP_SEL			(0x0FD)
#define TOMTOM_A_CDC_MAD_INP_SEL__POR				(0x00)
#define TOMTOM_A_BIAS_REF_CTL			(0x100)
#define TOMTOM_A_BIAS_REF_CTL__POR				(0x1C)
#define TOMTOM_A_BIAS_CENTRAL_BG_CTL			(0x101)
#define TOMTOM_A_BIAS_CENTRAL_BG_CTL__POR				(0x50)
#define TOMTOM_A_BIAS_PRECHRG_CTL			(0x102)
#define TOMTOM_A_BIAS_PRECHRG_CTL__POR				(0x07)
#define TOMTOM_A_BIAS_CURR_CTL_1			(0x103)
#define TOMTOM_A_BIAS_CURR_CTL_1__POR				(0x52)
#define TOMTOM_A_BIAS_CURR_CTL_2			(0x104)
#define TOMTOM_A_BIAS_CURR_CTL_2__POR				(0x00)
#define TOMTOM_A_BIAS_OSC_BG_CTL			(0x105)
#define TOMTOM_A_BIAS_OSC_BG_CTL__POR				(0x36)
#define TOMTOM_A_CLK_BUFF_EN1			(0x108)
#define TOMTOM_A_CLK_BUFF_EN1__POR				(0x04)
#define TOMTOM_A_CLK_BUFF_EN2			(0x109)
#define TOMTOM_A_CLK_BUFF_EN2__POR				(0x02)
#define TOMTOM_A_LDO_L_MODE_1			(0x10A)
#define TOMTOM_A_LDO_L_MODE_1__POR				(0x08)
#define TOMTOM_A_LDO_L_MODE_2			(0x10B)
#define TOMTOM_A_LDO_L_MODE_2__POR				(0x50)
#define TOMTOM_A_LDO_L_CTRL_1			(0x10C)
#define TOMTOM_A_LDO_L_CTRL_1__POR				(0x70)
#define TOMTOM_A_LDO_L_CTRL_2			(0x10D)
#define TOMTOM_A_LDO_L_CTRL_2__POR				(0x55)
#define TOMTOM_A_LDO_L_CTRL_3			(0x10E)
#define TOMTOM_A_LDO_L_CTRL_3__POR				(0x56)
#define TOMTOM_A_LDO_L_CTRL_4			(0x10F)
#define TOMTOM_A_LDO_L_CTRL_4__POR				(0x55)
#define TOMTOM_A_LDO_H_MODE_1			(0x110)
#define TOMTOM_A_LDO_H_MODE_1__POR				(0x65)
#define TOMTOM_A_LDO_H_MODE_2			(0x111)
#define TOMTOM_A_LDO_H_MODE_2__POR				(0xA8)
#define TOMTOM_A_LDO_H_LOOP_CTL			(0x112)
#define TOMTOM_A_LDO_H_LOOP_CTL__POR				(0x6B)
#define TOMTOM_A_LDO_H_COMP_1			(0x113)
#define TOMTOM_A_LDO_H_COMP_1__POR				(0x84)
#define TOMTOM_A_LDO_H_COMP_2			(0x114)
#define TOMTOM_A_LDO_H_COMP_2__POR				(0xE0)
#define TOMTOM_A_LDO_H_BIAS_1			(0x115)
#define TOMTOM_A_LDO_H_BIAS_1__POR				(0x6D)
#define TOMTOM_A_LDO_H_BIAS_2			(0x116)
#define TOMTOM_A_LDO_H_BIAS_2__POR				(0xA5)
#define TOMTOM_A_LDO_H_BIAS_3			(0x117)
#define TOMTOM_A_LDO_H_BIAS_3__POR				(0x60)
#define TOMTOM_A_VBAT_CLK			(0x118)
#define TOMTOM_A_VBAT_CLK__POR				(0x03)
#define TOMTOM_A_VBAT_LOOP			(0x119)
#define TOMTOM_A_VBAT_LOOP__POR				(0x02)
#define TOMTOM_A_VBAT_REF			(0x11A)
#define TOMTOM_A_VBAT_REF__POR				(0x20)
#define TOMTOM_A_VBAT_ADC_TEST			(0x11B)
#define TOMTOM_A_VBAT_ADC_TEST__POR				(0x00)
#define TOMTOM_A_VBAT_FE			(0x11C)
#define TOMTOM_A_VBAT_FE__POR				(0x48)
#define TOMTOM_A_VBAT_BIAS_1			(0x11D)
#define TOMTOM_A_VBAT_BIAS_1__POR				(0x03)
#define TOMTOM_A_VBAT_BIAS_2			(0x11E)
#define TOMTOM_A_VBAT_BIAS_2__POR				(0x00)
#define TOMTOM_A_VBAT_ADC_DATA_MSB			(0x11F)
#define TOMTOM_A_VBAT_ADC_DATA_MSB__POR				(0x00)
#define TOMTOM_A_VBAT_ADC_DATA_LSB			(0x120)
#define TOMTOM_A_VBAT_ADC_DATA_LSB__POR				(0x00)
#define TOMTOM_A_FLL_NREF			(0x121)
#define TOMTOM_A_FLL_NREF__POR				(0x12)
#define TOMTOM_A_FLL_KDCO_TUNE			(0x122)
#define TOMTOM_A_FLL_KDCO_TUNE__POR				(0x05)
#define TOMTOM_A_FLL_LOCK_THRESH			(0x123)
#define TOMTOM_A_FLL_LOCK_THRESH__POR				(0xC2)
#define TOMTOM_A_FLL_LOCK_DET_COUNT			(0x124)
#define TOMTOM_A_FLL_LOCK_DET_COUNT__POR				(0x40)
#define TOMTOM_A_FLL_DAC_THRESHOLD			(0x125)
#define TOMTOM_A_FLL_DAC_THRESHOLD__POR				(0xC8)
#define TOMTOM_A_FLL_TEST_DCO_FREERUN			(0x126)
#define TOMTOM_A_FLL_TEST_DCO_FREERUN__POR				(0x00)
#define TOMTOM_A_FLL_TEST_ENABLE			(0x127)
#define TOMTOM_A_FLL_TEST_ENABLE__POR				(0x00)
#define TOMTOM_A_MICB_CFILT_1_CTL			(0x128)
#define TOMTOM_A_MICB_CFILT_1_CTL__POR				(0x40)
#define TOMTOM_A_MICB_CFILT_1_VAL			(0x129)
#define TOMTOM_A_MICB_CFILT_1_VAL__POR				(0x80)
#define TOMTOM_A_MICB_CFILT_1_PRECHRG			(0x12A)
#define TOMTOM_A_MICB_CFILT_1_PRECHRG__POR				(0x38)
#define TOMTOM_A_MICB_1_CTL			(0x12B)
#define TOMTOM_A_MICB_1_CTL__POR				(0x16)
#define TOMTOM_A_MICB_1_INT_RBIAS			(0x12C)
#define TOMTOM_A_MICB_1_INT_RBIAS__POR				(0x24)
#define TOMTOM_A_MICB_1_MBHC			(0x12D)
#define TOMTOM_A_MICB_1_MBHC__POR				(0x01)
#define TOMTOM_A_MICB_CFILT_2_CTL			(0x12E)
#define TOMTOM_A_MICB_CFILT_2_CTL__POR				(0x41)
#define TOMTOM_A_MICB_CFILT_2_VAL			(0x12F)
#define TOMTOM_A_MICB_CFILT_2_VAL__POR				(0x80)
#define TOMTOM_A_MICB_CFILT_2_PRECHRG			(0x130)
#define TOMTOM_A_MICB_CFILT_2_PRECHRG__POR				(0x38)
#define TOMTOM_A_MICB_2_CTL			(0x131)
#define TOMTOM_A_MICB_2_CTL__POR				(0x16)
#define TOMTOM_A_MICB_2_INT_RBIAS			(0x132)
#define TOMTOM_A_MICB_2_INT_RBIAS__POR				(0x24)
#define TOMTOM_A_MICB_2_MBHC			(0x133)
#define TOMTOM_A_MICB_2_MBHC__POR				(0x02)
#define TOMTOM_A_MICB_CFILT_3_CTL			(0x134)
#define TOMTOM_A_MICB_CFILT_3_CTL__POR				(0x40)
#define TOMTOM_A_MICB_CFILT_3_VAL			(0x135)
#define TOMTOM_A_MICB_CFILT_3_VAL__POR				(0x80)
#define TOMTOM_A_MICB_CFILT_3_PRECHRG			(0x136)
#define TOMTOM_A_MICB_CFILT_3_PRECHRG__POR				(0x38)
#define TOMTOM_A_MICB_3_CTL			(0x137)
#define TOMTOM_A_MICB_3_CTL__POR				(0x16)
#define TOMTOM_A_MICB_3_INT_RBIAS			(0x138)
#define TOMTOM_A_MICB_3_INT_RBIAS__POR				(0x24)
#define TOMTOM_A_MICB_3_MBHC			(0x139)
#define TOMTOM_A_MICB_3_MBHC__POR				(0x00)
#define TOMTOM_A_MICB_4_CTL			(0x13A)
#define TOMTOM_A_MICB_4_CTL__POR				(0x16)
#define TOMTOM_A_MICB_4_INT_RBIAS			(0x13B)
#define TOMTOM_A_MICB_4_INT_RBIAS__POR				(0x24)
#define TOMTOM_A_MICB_4_MBHC			(0x13C)
#define TOMTOM_A_MICB_4_MBHC__POR				(0x01)
#define TOMTOM_A_SPKR_DRV2_EN			(0x13D)
#define TOMTOM_A_SPKR_DRV2_EN__POR				(0x6F)
#define TOMTOM_A_SPKR_DRV2_GAIN			(0x13E)
#define TOMTOM_A_SPKR_DRV2_GAIN__POR				(0x00)
#define TOMTOM_A_SPKR_DRV2_DAC_CTL			(0x13F)
#define TOMTOM_A_SPKR_DRV2_DAC_CTL__POR				(0x04)
#define TOMTOM_A_SPKR_DRV2_OCP_CTL			(0x140)
#define TOMTOM_A_SPKR_DRV2_OCP_CTL__POR				(0x97)
#define TOMTOM_A_SPKR_DRV2_CLIP_DET			(0x141)
#define TOMTOM_A_SPKR_DRV2_CLIP_DET__POR				(0x01)
#define TOMTOM_A_SPKR_DRV2_DBG_DAC			(0x142)
#define TOMTOM_A_SPKR_DRV2_DBG_DAC__POR				(0x05)
#define TOMTOM_A_SPKR_DRV2_DBG_PA			(0x143)
#define TOMTOM_A_SPKR_DRV2_DBG_PA__POR				(0x18)
#define TOMTOM_A_SPKR_DRV2_DBG_PWRSTG			(0x144)
#define TOMTOM_A_SPKR_DRV2_DBG_PWRSTG__POR				(0x00)
#define TOMTOM_A_SPKR_DRV2_BIAS_LDO			(0x145)
#define TOMTOM_A_SPKR_DRV2_BIAS_LDO__POR				(0x45)
#define TOMTOM_A_SPKR_DRV2_BIAS_INT			(0x146)
#define TOMTOM_A_SPKR_DRV2_BIAS_INT__POR				(0xA5)
#define TOMTOM_A_SPKR_DRV2_BIAS_PA			(0x147)
#define TOMTOM_A_SPKR_DRV2_BIAS_PA__POR				(0x55)
#define TOMTOM_A_SPKR_DRV2_STATUS_OCP			(0x148)
#define TOMTOM_A_SPKR_DRV2_STATUS_OCP__POR				(0x00)
#define TOMTOM_A_SPKR_DRV2_STATUS_PA			(0x149)
#define TOMTOM_A_SPKR_DRV2_STATUS_PA__POR				(0x00)
#define TOMTOM_A_MBHC_INSERT_DETECT			(0x14A)
#define TOMTOM_A_MBHC_INSERT_DETECT__POR				(0x00)
#define TOMTOM_A_MBHC_INSERT_DET_STATUS			(0x14B)
#define TOMTOM_A_MBHC_INSERT_DET_STATUS__POR				(0x00)
#define TOMTOM_A_TX_COM_BIAS			(0x14C)
#define TOMTOM_A_TX_COM_BIAS__POR				(0xF0)
#define TOMTOM_A_MBHC_INSERT_DETECT2			(0x14D)
#define TOMTOM_A_MBHC_INSERT_DETECT2__POR				(0xD0)
#define TOMTOM_A_MBHC_SCALING_MUX_1			(0x14E)
#define TOMTOM_A_MBHC_SCALING_MUX_1__POR				(0x00)
#define TOMTOM_A_MBHC_SCALING_MUX_2			(0x14F)
#define TOMTOM_A_MBHC_SCALING_MUX_2__POR				(0x80)
#define TOMTOM_A_MAD_ANA_CTRL			(0x150)
#define TOMTOM_A_MAD_ANA_CTRL__POR				(0xF1)
#define TOMTOM_A_TX_SUP_SWITCH_CTRL_1			(0x151)
#define TOMTOM_A_TX_SUP_SWITCH_CTRL_1__POR				(0x00)
#define TOMTOM_A_TX_SUP_SWITCH_CTRL_2			(0x152)
#define TOMTOM_A_TX_SUP_SWITCH_CTRL_2__POR				(0x80)
#define TOMTOM_A_TX_1_GAIN			(0x153)
#define TOMTOM_A_TX_1_GAIN__POR				(0x02)
#define TOMTOM_A_TX_1_2_TEST_EN			(0x154)
#define TOMTOM_A_TX_1_2_TEST_EN__POR				(0xCC)
#define TOMTOM_A_TX_2_GAIN			(0x155)
#define TOMTOM_A_TX_2_GAIN__POR				(0x02)
#define TOMTOM_A_TX_1_2_ADC_IB			(0x156)
#define TOMTOM_A_TX_1_2_ADC_IB__POR				(0x44)
#define TOMTOM_A_TX_1_2_ATEST_REFCTRL			(0x157)
#define TOMTOM_A_TX_1_2_ATEST_REFCTRL__POR				(0x00)
#define TOMTOM_A_TX_1_2_TEST_CTL			(0x158)
#define TOMTOM_A_TX_1_2_TEST_CTL__POR				(0x38)
#define TOMTOM_A_TX_1_2_TEST_BLOCK_EN			(0x159)
#define TOMTOM_A_TX_1_2_TEST_BLOCK_EN__POR				(0xFC)
#define TOMTOM_A_TX_1_2_TXFE_CLKDIV			(0x15A)
#define TOMTOM_A_TX_1_2_TXFE_CLKDIV__POR				(0x55)
#define TOMTOM_A_TX_1_2_SAR_ERR_CH1			(0x15B)
#define TOMTOM_A_TX_1_2_SAR_ERR_CH1__POR				(0x00)
#define TOMTOM_A_TX_1_2_SAR_ERR_CH2			(0x15C)
#define TOMTOM_A_TX_1_2_SAR_ERR_CH2__POR				(0x00)
#define TOMTOM_A_TX_3_GAIN			(0x15D)
#define TOMTOM_A_TX_3_GAIN__POR				(0x02)
#define TOMTOM_A_TX_3_4_TEST_EN			(0x15E)
#define TOMTOM_A_TX_3_4_TEST_EN__POR				(0xCC)
#define TOMTOM_A_TX_4_GAIN			(0x15F)
#define TOMTOM_A_TX_4_GAIN__POR				(0x02)
#define TOMTOM_A_TX_3_4_ADC_IB			(0x160)
#define TOMTOM_A_TX_3_4_ADC_IB__POR				(0x44)
#define TOMTOM_A_TX_3_4_ATEST_REFCTRL			(0x161)
#define TOMTOM_A_TX_3_4_ATEST_REFCTRL__POR				(0x00)
#define TOMTOM_A_TX_3_4_TEST_CTL			(0x162)
#define TOMTOM_A_TX_3_4_TEST_CTL__POR				(0x38)
#define TOMTOM_A_TX_3_4_TEST_BLOCK_EN			(0x163)
#define TOMTOM_A_TX_3_4_TEST_BLOCK_EN__POR				(0xFC)
#define TOMTOM_A_TX_3_4_TXFE_CKDIV			(0x164)
#define TOMTOM_A_TX_3_4_TXFE_CKDIV__POR				(0x55)
#define TOMTOM_A_TX_3_4_SAR_ERR_CH3			(0x165)
#define TOMTOM_A_TX_3_4_SAR_ERR_CH3__POR				(0x00)
#define TOMTOM_A_TX_3_4_SAR_ERR_CH4			(0x166)
#define TOMTOM_A_TX_3_4_SAR_ERR_CH4__POR				(0x00)
#define TOMTOM_A_TX_5_GAIN			(0x167)
#define TOMTOM_A_TX_5_GAIN__POR				(0x02)
#define TOMTOM_A_TX_5_6_TEST_EN			(0x168)
#define TOMTOM_A_TX_5_6_TEST_EN__POR				(0xCC)
#define TOMTOM_A_TX_6_GAIN			(0x169)
#define TOMTOM_A_TX_6_GAIN__POR				(0x02)
#define TOMTOM_A_TX_5_6_ADC_IB			(0x16A)
#define TOMTOM_A_TX_5_6_ADC_IB__POR				(0x44)
#define TOMTOM_A_TX_5_6_ATEST_REFCTRL			(0x16B)
#define TOMTOM_A_TX_5_6_ATEST_REFCTRL__POR				(0x00)
#define TOMTOM_A_TX_5_6_TEST_CTL			(0x16C)
#define TOMTOM_A_TX_5_6_TEST_CTL__POR				(0x38)
#define TOMTOM_A_TX_5_6_TEST_BLOCK_EN			(0x16D)
#define TOMTOM_A_TX_5_6_TEST_BLOCK_EN__POR				(0xFC)
#define TOMTOM_A_TX_5_6_TXFE_CKDIV			(0x16E)
#define TOMTOM_A_TX_5_6_TXFE_CKDIV__POR				(0x55)
#define TOMTOM_A_TX_5_6_SAR_ERR_CH5			(0x16F)
#define TOMTOM_A_TX_5_6_SAR_ERR_CH5__POR				(0x00)
#define TOMTOM_A_TX_5_6_SAR_ERR_CH6			(0x170)
#define TOMTOM_A_TX_5_6_SAR_ERR_CH6__POR				(0x00)
#define TOMTOM_A_TX_7_MBHC_EN			(0x171)
#define TOMTOM_A_TX_7_MBHC_EN__POR				(0x0C)
#define TOMTOM_A_TX_7_MBHC_ATEST_REFCTRL			(0x172)
#define TOMTOM_A_TX_7_MBHC_ATEST_REFCTRL__POR				(0x00)
#define TOMTOM_A_TX_7_MBHC_ADC			(0x173)
#define TOMTOM_A_TX_7_MBHC_ADC__POR				(0x44)
#define TOMTOM_A_TX_7_MBHC_TEST_CTL			(0x174)
#define TOMTOM_A_TX_7_MBHC_TEST_CTL__POR				(0x38)
#define TOMTOM_A_TX_7_MBHC_SAR_ERR			(0x175)
#define TOMTOM_A_TX_7_MBHC_SAR_ERR__POR				(0x00)
#define TOMTOM_A_TX_7_TXFE_CLKDIV			(0x176)
#define TOMTOM_A_TX_7_TXFE_CLKDIV__POR				(0x8B)
#define TOMTOM_A_RCO_CTRL			(0x177)
#define TOMTOM_A_RCO_CTRL__POR				(0x00)
#define TOMTOM_A_RCO_CALIBRATION_CTRL1			(0x178)
#define TOMTOM_A_RCO_CALIBRATION_CTRL1__POR				(0x00)
#define TOMTOM_A_RCO_CALIBRATION_CTRL2			(0x179)
#define TOMTOM_A_RCO_CALIBRATION_CTRL2__POR				(0x00)
#define TOMTOM_A_RCO_CALIBRATION_CTRL3			(0x17A)
#define TOMTOM_A_RCO_CALIBRATION_CTRL3__POR				(0x00)
#define TOMTOM_A_RCO_TEST_CTRL			(0x17B)
#define TOMTOM_A_RCO_TEST_CTRL__POR				(0x00)
#define TOMTOM_A_RCO_CALIBRATION_RESULT1			(0x17C)
#define TOMTOM_A_RCO_CALIBRATION_RESULT1__POR				(0x00)
#define TOMTOM_A_RCO_CALIBRATION_RESULT2			(0x17D)
#define TOMTOM_A_RCO_CALIBRATION_RESULT2__POR				(0x00)
#define TOMTOM_A_BUCK_MODE_1			(0x181)
#define TOMTOM_A_BUCK_MODE_1__POR				(0x21)
#define TOMTOM_A_BUCK_MODE_2			(0x182)
#define TOMTOM_A_BUCK_MODE_2__POR				(0xFF)
#define TOMTOM_A_BUCK_MODE_3			(0x183)
#define TOMTOM_A_BUCK_MODE_3__POR				(0xCE)
#define TOMTOM_A_BUCK_MODE_4			(0x184)
#define TOMTOM_A_BUCK_MODE_4__POR				(0x3A)
#define TOMTOM_A_BUCK_MODE_5			(0x185)
#define TOMTOM_A_BUCK_MODE_5__POR				(0x00)
#define TOMTOM_A_BUCK_CTRL_VCL_1			(0x186)
#define TOMTOM_A_BUCK_CTRL_VCL_1__POR				(0x08)
#define TOMTOM_A_BUCK_CTRL_VCL_2			(0x187)
#define TOMTOM_A_BUCK_CTRL_VCL_2__POR				(0xA3)
#define TOMTOM_A_BUCK_CTRL_VCL_3			(0x188)
#define TOMTOM_A_BUCK_CTRL_VCL_3__POR				(0x82)
#define TOMTOM_A_BUCK_CTRL_CCL_1			(0x189)
#define TOMTOM_A_BUCK_CTRL_CCL_1__POR				(0x5B)
#define TOMTOM_A_BUCK_CTRL_CCL_2			(0x18A)
#define TOMTOM_A_BUCK_CTRL_CCL_2__POR				(0xDC)
#define TOMTOM_A_BUCK_CTRL_CCL_3			(0x18B)
#define TOMTOM_A_BUCK_CTRL_CCL_3__POR				(0x6A)
#define TOMTOM_A_BUCK_CTRL_CCL_4			(0x18C)
#define TOMTOM_A_BUCK_CTRL_CCL_4__POR				(0x51)
#define TOMTOM_A_BUCK_CTRL_PWM_DRVR_1			(0x18D)
#define TOMTOM_A_BUCK_CTRL_PWM_DRVR_1__POR				(0x50)
#define TOMTOM_A_BUCK_CTRL_PWM_DRVR_2			(0x18E)
#define TOMTOM_A_BUCK_CTRL_PWM_DRVR_2__POR				(0x64)
#define TOMTOM_A_BUCK_CTRL_PWM_DRVR_3			(0x18F)
#define TOMTOM_A_BUCK_CTRL_PWM_DRVR_3__POR				(0x77)
#define TOMTOM_A_BUCK_TMUX_A_D			(0x190)
#define TOMTOM_A_BUCK_TMUX_A_D__POR				(0x00)
#define TOMTOM_A_NCP_BUCKREF			(0x191)
#define TOMTOM_A_NCP_BUCKREF__POR				(0x00)
#define TOMTOM_A_NCP_EN			(0x192)
#define TOMTOM_A_NCP_EN__POR				(0xFE)
#define TOMTOM_A_NCP_CLK			(0x193)
#define TOMTOM_A_NCP_CLK__POR				(0x94)
#define TOMTOM_A_NCP_STATIC			(0x194)
#define TOMTOM_A_NCP_STATIC__POR				(0x28)
#define TOMTOM_A_NCP_VTH_LOW			(0x195)
#define TOMTOM_A_NCP_VTH_LOW__POR				(0x88)
#define TOMTOM_A_NCP_VTH_HIGH			(0x196)
#define TOMTOM_A_NCP_VTH_HIGH__POR				(0xA0)
#define TOMTOM_A_NCP_ATEST			(0x197)
#define TOMTOM_A_NCP_ATEST__POR				(0x00)
#define TOMTOM_A_NCP_DTEST			(0x198)
#define TOMTOM_A_NCP_DTEST__POR				(0x10)
#define TOMTOM_A_NCP_DLY1			(0x199)
#define TOMTOM_A_NCP_DLY1__POR				(0x06)
#define TOMTOM_A_NCP_DLY2			(0x19A)
#define TOMTOM_A_NCP_DLY2__POR				(0x06)
#define TOMTOM_A_RX_AUX_SW_CTL			(0x19B)
#define TOMTOM_A_RX_AUX_SW_CTL__POR				(0x00)
#define TOMTOM_A_RX_PA_AUX_IN_CONN			(0x19C)
#define TOMTOM_A_RX_PA_AUX_IN_CONN__POR				(0x00)
#define TOMTOM_A_RX_COM_TIMER_DIV			(0x19E)
#define TOMTOM_A_RX_COM_TIMER_DIV__POR				(0xE8)
#define TOMTOM_A_RX_COM_OCP_CTL			(0x19F)
#define TOMTOM_A_RX_COM_OCP_CTL__POR				(0x1F)
#define TOMTOM_A_RX_COM_OCP_COUNT			(0x1A0)
#define TOMTOM_A_RX_COM_OCP_COUNT__POR				(0x77)
#define TOMTOM_A_RX_COM_DAC_CTL			(0x1A1)
#define TOMTOM_A_RX_COM_DAC_CTL__POR				(0x00)
#define TOMTOM_A_RX_COM_BIAS			(0x1A2)
#define TOMTOM_A_RX_COM_BIAS__POR				(0x20)
#define TOMTOM_A_RX_HPH_AUTO_CHOP			(0x1A4)
#define TOMTOM_A_RX_HPH_AUTO_CHOP__POR				(0x38)
#define TOMTOM_A_RX_HPH_CHOP_CTL			(0x1A5)
#define TOMTOM_A_RX_HPH_CHOP_CTL__POR				(0xA4)
#define TOMTOM_A_RX_HPH_BIAS_PA			(0x1A6)
#define TOMTOM_A_RX_HPH_BIAS_PA__POR				(0x7A)
#define TOMTOM_A_RX_HPH_BIAS_LDO			(0x1A7)
#define TOMTOM_A_RX_HPH_BIAS_LDO__POR				(0x87)
#define TOMTOM_A_RX_HPH_BIAS_CNP			(0x1A8)
#define TOMTOM_A_RX_HPH_BIAS_CNP__POR				(0x8A)
#define TOMTOM_A_RX_HPH_BIAS_WG_OCP			(0x1A9)
#define TOMTOM_A_RX_HPH_BIAS_WG_OCP__POR				(0x2A)
#define TOMTOM_A_RX_HPH_OCP_CTL			(0x1AA)
#define TOMTOM_A_RX_HPH_OCP_CTL__POR				(0x69)
#define TOMTOM_A_RX_HPH_CNP_EN			(0x1AB)
#define TOMTOM_A_RX_HPH_CNP_EN__POR				(0x80)
#define TOMTOM_A_RX_HPH_CNP_WG_CTL			(0x1AC)
#define TOMTOM_A_RX_HPH_CNP_WG_CTL__POR				(0xDA)
#define TOMTOM_A_RX_HPH_CNP_WG_TIME			(0x1AD)
#define TOMTOM_A_RX_HPH_CNP_WG_TIME__POR				(0x15)
#define TOMTOM_A_RX_HPH_L_GAIN			(0x1AE)
#define TOMTOM_A_RX_HPH_L_GAIN__POR				(0xC0)
#define TOMTOM_A_RX_HPH_L_TEST			(0x1AF)
#define TOMTOM_A_RX_HPH_L_TEST__POR				(0x02)
#define TOMTOM_A_RX_HPH_L_PA_CTL			(0x1B0)
#define TOMTOM_A_RX_HPH_L_PA_CTL__POR				(0x42)
#define TOMTOM_A_RX_HPH_L_DAC_CTL			(0x1B1)
#define TOMTOM_A_RX_HPH_L_DAC_CTL__POR				(0x00)
#define TOMTOM_A_RX_HPH_L_ATEST			(0x1B2)
#define TOMTOM_A_RX_HPH_L_ATEST__POR				(0x00)
#define TOMTOM_A_RX_HPH_L_STATUS			(0x1B3)
#define TOMTOM_A_RX_HPH_L_STATUS__POR				(0x00)
#define TOMTOM_A_RX_HPH_R_GAIN			(0x1B4)
#define TOMTOM_A_RX_HPH_R_GAIN__POR				(0x00)
#define TOMTOM_A_RX_HPH_R_TEST			(0x1B5)
#define TOMTOM_A_RX_HPH_R_TEST__POR				(0x02)
#define TOMTOM_A_RX_HPH_R_PA_CTL			(0x1B6)
#define TOMTOM_A_RX_HPH_R_PA_CTL__POR				(0x42)
#define TOMTOM_A_RX_HPH_R_DAC_CTL			(0x1B7)
#define TOMTOM_A_RX_HPH_R_DAC_CTL__POR				(0x00)
#define TOMTOM_A_RX_HPH_R_ATEST			(0x1B8)
#define TOMTOM_A_RX_HPH_R_ATEST__POR				(0x00)
#define TOMTOM_A_RX_HPH_R_STATUS			(0x1B9)
#define TOMTOM_A_RX_HPH_R_STATUS__POR				(0x00)
#define TOMTOM_A_RX_EAR_BIAS_PA			(0x1BA)
#define TOMTOM_A_RX_EAR_BIAS_PA__POR				(0x76)
#define TOMTOM_A_RX_EAR_BIAS_CMBUFF			(0x1BB)
#define TOMTOM_A_RX_EAR_BIAS_CMBUFF__POR				(0xA0)
#define TOMTOM_A_RX_EAR_EN			(0x1BC)
#define TOMTOM_A_RX_EAR_EN__POR				(0x00)
#define TOMTOM_A_RX_EAR_GAIN			(0x1BD)
#define TOMTOM_A_RX_EAR_GAIN__POR				(0x02)
#define TOMTOM_A_RX_EAR_CMBUFF			(0x1BE)
#define TOMTOM_A_RX_EAR_CMBUFF__POR				(0x05)
#define TOMTOM_A_RX_EAR_ICTL			(0x1BF)
#define TOMTOM_A_RX_EAR_ICTL__POR				(0x40)
#define TOMTOM_A_RX_EAR_CCOMP			(0x1C0)
#define TOMTOM_A_RX_EAR_CCOMP__POR				(0x08)
#define TOMTOM_A_RX_EAR_VCM			(0x1C1)
#define TOMTOM_A_RX_EAR_VCM__POR				(0x03)
#define TOMTOM_A_RX_EAR_CNP			(0x1C2)
#define TOMTOM_A_RX_EAR_CNP__POR				(0xC0)
#define TOMTOM_A_RX_EAR_DAC_CTL_ATEST			(0x1C3)
#define TOMTOM_A_RX_EAR_DAC_CTL_ATEST__POR				(0x00)
#define TOMTOM_A_RX_EAR_STATUS			(0x1C5)
#define TOMTOM_A_RX_EAR_STATUS__POR				(0x04)
#define TOMTOM_A_RX_LINE_BIAS_PA			(0x1C6)
#define TOMTOM_A_RX_LINE_BIAS_PA__POR				(0x78)
#define TOMTOM_A_RX_BUCK_BIAS1			(0x1C7)
#define TOMTOM_A_RX_BUCK_BIAS1__POR				(0x42)
#define TOMTOM_A_RX_BUCK_BIAS2			(0x1C8)
#define TOMTOM_A_RX_BUCK_BIAS2__POR				(0x84)
#define TOMTOM_A_RX_LINE_COM			(0x1C9)
#define TOMTOM_A_RX_LINE_COM__POR				(0x80)
#define TOMTOM_A_RX_LINE_CNP_EN			(0x1CA)
#define TOMTOM_A_RX_LINE_CNP_EN__POR				(0x00)
#define TOMTOM_A_RX_LINE_CNP_WG_CTL			(0x1CB)
#define TOMTOM_A_RX_LINE_CNP_WG_CTL__POR				(0x00)
#define TOMTOM_A_RX_LINE_CNP_WG_TIME			(0x1CC)
#define TOMTOM_A_RX_LINE_CNP_WG_TIME__POR				(0x04)
#define TOMTOM_A_RX_LINE_1_GAIN			(0x1CD)
#define TOMTOM_A_RX_LINE_1_GAIN__POR				(0x00)
#define TOMTOM_A_RX_LINE_1_TEST			(0x1CE)
#define TOMTOM_A_RX_LINE_1_TEST__POR				(0x02)
#define TOMTOM_A_RX_LINE_1_DAC_CTL			(0x1CF)
#define TOMTOM_A_RX_LINE_1_DAC_CTL__POR				(0x00)
#define TOMTOM_A_RX_LINE_1_STATUS			(0x1D0)
#define TOMTOM_A_RX_LINE_1_STATUS__POR				(0x00)
#define TOMTOM_A_RX_LINE_2_GAIN			(0x1D1)
#define TOMTOM_A_RX_LINE_2_GAIN__POR				(0x00)
#define TOMTOM_A_RX_LINE_2_TEST			(0x1D2)
#define TOMTOM_A_RX_LINE_2_TEST__POR				(0x02)
#define TOMTOM_A_RX_LINE_2_DAC_CTL			(0x1D3)
#define TOMTOM_A_RX_LINE_2_DAC_CTL__POR				(0x00)
#define TOMTOM_A_RX_LINE_2_STATUS			(0x1D4)
#define TOMTOM_A_RX_LINE_2_STATUS__POR				(0x00)
#define TOMTOM_A_RX_LINE_3_GAIN			(0x1D5)
#define TOMTOM_A_RX_LINE_3_GAIN__POR				(0x00)
#define TOMTOM_A_RX_LINE_3_TEST			(0x1D6)
#define TOMTOM_A_RX_LINE_3_TEST__POR				(0x02)
#define TOMTOM_A_RX_LINE_3_DAC_CTL			(0x1D7)
#define TOMTOM_A_RX_LINE_3_DAC_CTL__POR				(0x00)
#define TOMTOM_A_RX_LINE_3_STATUS			(0x1D8)
#define TOMTOM_A_RX_LINE_3_STATUS__POR				(0x00)
#define TOMTOM_A_RX_LINE_4_GAIN			(0x1D9)
#define TOMTOM_A_RX_LINE_4_GAIN__POR				(0x00)
#define TOMTOM_A_RX_LINE_4_TEST			(0x1DA)
#define TOMTOM_A_RX_LINE_4_TEST__POR				(0x02)
#define TOMTOM_A_RX_LINE_4_DAC_CTL			(0x1DB)
#define TOMTOM_A_RX_LINE_4_DAC_CTL__POR				(0x00)
#define TOMTOM_A_RX_LINE_4_STATUS			(0x1DC)
#define TOMTOM_A_RX_LINE_4_STATUS__POR				(0x00)
#define TOMTOM_A_RX_LINE_CNP_DBG			(0x1DD)
#define TOMTOM_A_RX_LINE_CNP_DBG__POR				(0x00)
#define TOMTOM_A_SPKR_DRV1_EN			(0x1DF)
#define TOMTOM_A_SPKR_DRV1_EN__POR				(0x6F)
#define TOMTOM_A_SPKR_DRV1_GAIN			(0x1E0)
#define TOMTOM_A_SPKR_DRV1_GAIN__POR				(0x00)
#define TOMTOM_A_SPKR_DRV1_DAC_CTL			(0x1E1)
#define TOMTOM_A_SPKR_DRV1_DAC_CTL__POR				(0x04)
#define TOMTOM_A_SPKR_DRV1_OCP_CTL			(0x1E2)
#define TOMTOM_A_SPKR_DRV1_OCP_CTL__POR				(0x97)
#define TOMTOM_A_SPKR_DRV1_CLIP_DET			(0x1E3)
#define TOMTOM_A_SPKR_DRV1_CLIP_DET__POR				(0x01)
#define TOMTOM_A_SPKR_DRV1_IEC			(0x1E4)
#define TOMTOM_A_SPKR_DRV1_IEC__POR				(0x00)
#define TOMTOM_A_SPKR_DRV1_DBG_DAC			(0x1E5)
#define TOMTOM_A_SPKR_DRV1_DBG_DAC__POR				(0x05)
#define TOMTOM_A_SPKR_DRV1_DBG_PA			(0x1E6)
#define TOMTOM_A_SPKR_DRV1_DBG_PA__POR				(0x18)
#define TOMTOM_A_SPKR_DRV1_DBG_PWRSTG			(0x1E7)
#define TOMTOM_A_SPKR_DRV1_DBG_PWRSTG__POR				(0x00)
#define TOMTOM_A_SPKR_DRV1_BIAS_LDO			(0x1E8)
#define TOMTOM_A_SPKR_DRV1_BIAS_LDO__POR				(0x45)
#define TOMTOM_A_SPKR_DRV1_BIAS_INT			(0x1E9)
#define TOMTOM_A_SPKR_DRV1_BIAS_INT__POR				(0xA5)
#define TOMTOM_A_SPKR_DRV1_BIAS_PA			(0x1EA)
#define TOMTOM_A_SPKR_DRV1_BIAS_PA__POR				(0x55)
#define TOMTOM_A_SPKR_DRV1_STATUS_OCP			(0x1EB)
#define TOMTOM_A_SPKR_DRV1_STATUS_OCP__POR				(0x00)
#define TOMTOM_A_SPKR_DRV1_STATUS_PA			(0x1EC)
#define TOMTOM_A_SPKR_DRV1_STATUS_PA__POR				(0x00)
#define TOMTOM_A_SPKR1_PROT_EN			(0x1ED)
#define TOMTOM_A_SPKR1_PROT_EN__POR				(0x00)
#define TOMTOM_A_SPKR1_PROT_ADC_TEST_EN			(0x1EE)
#define TOMTOM_A_SPKR1_PROT_ADC_TEST_EN__POR				(0x44)
#define TOMTOM_A_SPKR1_PROT_ATEST			(0x1EF)
#define TOMTOM_A_SPKR1_PROT_ATEST__POR				(0x00)
#define TOMTOM_A_SPKR1_PROT_LDO_CTRL			(0x1F0)
#define TOMTOM_A_SPKR1_PROT_LDO_CTRL__POR				(0x00)
#define TOMTOM_A_SPKR1_PROT_ISENSE_CTRL			(0x1F1)
#define TOMTOM_A_SPKR1_PROT_ISENSE_CTRL__POR				(0x00)
#define TOMTOM_A_SPKR1_PROT_VSENSE_CTRL			(0x1F2)
#define TOMTOM_A_SPKR1_PROT_VSENSE_CTRL__POR				(0x00)
#define TOMTOM_A_SPKR2_PROT_EN			(0x1F3)
#define TOMTOM_A_SPKR2_PROT_EN__POR				(0x00)
#define TOMTOM_A_SPKR2_PROT_ADC_TEST_EN			(0x1F4)
#define TOMTOM_A_SPKR2_PROT_ADC_TEST_EN__POR				(0x44)
#define TOMTOM_A_SPKR2_PROT_ATEST			(0x1F5)
#define TOMTOM_A_SPKR2_PROT_ATEST__POR				(0x00)
#define TOMTOM_A_SPKR2_PROT_LDO_CTRL			(0x1F6)
#define TOMTOM_A_SPKR2_PROT_LDO_CTRL__POR				(0x00)
#define TOMTOM_A_SPKR2_PROT_ISENSE_CTRL			(0x1F7)
#define TOMTOM_A_SPKR2_PROT_ISENSE_CTRL__POR				(0x00)
#define TOMTOM_A_SPKR2_PROT_VSENSE_CTRL			(0x1F8)
#define TOMTOM_A_SPKR2_PROT_VSENSE_CTRL__POR				(0x00)
#define TOMTOM_A_MBHC_HPH			(0x1FE)
#define TOMTOM_A_MBHC_HPH__POR				(0x44)
#define TOMTOM_A_CDC_ANC1_B1_CTL			(0x200)
#define TOMTOM_A_CDC_ANC1_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_ANC2_B1_CTL			(0x280)
#define TOMTOM_A_CDC_ANC2_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_ANC1_SHIFT			(0x201)
#define TOMTOM_A_CDC_ANC1_SHIFT__POR				(0x00)
#define TOMTOM_A_CDC_ANC2_SHIFT			(0x281)
#define TOMTOM_A_CDC_ANC2_SHIFT__POR				(0x00)
#define TOMTOM_A_CDC_ANC1_IIR_B1_CTL			(0x202)
#define TOMTOM_A_CDC_ANC1_IIR_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_ANC2_IIR_B1_CTL			(0x282)
#define TOMTOM_A_CDC_ANC2_IIR_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_ANC1_IIR_B2_CTL			(0x203)
#define TOMTOM_A_CDC_ANC1_IIR_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_ANC2_IIR_B2_CTL			(0x283)
#define TOMTOM_A_CDC_ANC2_IIR_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_ANC1_IIR_B3_CTL			(0x204)
#define TOMTOM_A_CDC_ANC1_IIR_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_ANC2_IIR_B3_CTL			(0x284)
#define TOMTOM_A_CDC_ANC2_IIR_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_ANC1_LPF_B1_CTL			(0x206)
#define TOMTOM_A_CDC_ANC1_LPF_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_ANC2_LPF_B1_CTL			(0x286)
#define TOMTOM_A_CDC_ANC2_LPF_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_ANC1_LPF_B2_CTL			(0x207)
#define TOMTOM_A_CDC_ANC1_LPF_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_ANC2_LPF_B2_CTL			(0x287)
#define TOMTOM_A_CDC_ANC2_LPF_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_ANC1_SPARE			(0x209)
#define TOMTOM_A_CDC_ANC1_SPARE__POR				(0x00)
#define TOMTOM_A_CDC_ANC2_SPARE			(0x289)
#define TOMTOM_A_CDC_ANC2_SPARE__POR				(0x00)
#define TOMTOM_A_CDC_ANC1_SMLPF_CTL			(0x20A)
#define TOMTOM_A_CDC_ANC1_SMLPF_CTL__POR				(0x00)
#define TOMTOM_A_CDC_ANC2_SMLPF_CTL			(0x28A)
#define TOMTOM_A_CDC_ANC2_SMLPF_CTL__POR				(0x00)
#define TOMTOM_A_CDC_ANC1_DCFLT_CTL			(0x20B)
#define TOMTOM_A_CDC_ANC1_DCFLT_CTL__POR				(0x00)
#define TOMTOM_A_CDC_ANC2_DCFLT_CTL			(0x28B)
#define TOMTOM_A_CDC_ANC2_DCFLT_CTL__POR				(0x00)
#define TOMTOM_A_CDC_ANC1_GAIN_CTL			(0x20C)
#define TOMTOM_A_CDC_ANC1_GAIN_CTL__POR				(0x00)
#define TOMTOM_A_CDC_ANC2_GAIN_CTL			(0x28C)
#define TOMTOM_A_CDC_ANC2_GAIN_CTL__POR				(0x00)
#define TOMTOM_A_CDC_ANC1_B2_CTL			(0x20D)
#define TOMTOM_A_CDC_ANC1_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_ANC2_B2_CTL			(0x28D)
#define TOMTOM_A_CDC_ANC2_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_TX1_VOL_CTL_TIMER			(0x220)
#define TOMTOM_A_CDC_TX1_VOL_CTL_TIMER__POR				(0x00)
#define TOMTOM_A_CDC_TX2_VOL_CTL_TIMER			(0x228)
#define TOMTOM_A_CDC_TX2_VOL_CTL_TIMER__POR				(0x00)
#define TOMTOM_A_CDC_TX3_VOL_CTL_TIMER			(0x230)
#define TOMTOM_A_CDC_TX3_VOL_CTL_TIMER__POR				(0x00)
#define TOMTOM_A_CDC_TX4_VOL_CTL_TIMER			(0x238)
#define TOMTOM_A_CDC_TX4_VOL_CTL_TIMER__POR				(0x00)
#define TOMTOM_A_CDC_TX5_VOL_CTL_TIMER			(0x240)
#define TOMTOM_A_CDC_TX5_VOL_CTL_TIMER__POR				(0x00)
#define TOMTOM_A_CDC_TX6_VOL_CTL_TIMER			(0x248)
#define TOMTOM_A_CDC_TX6_VOL_CTL_TIMER__POR				(0x00)
#define TOMTOM_A_CDC_TX7_VOL_CTL_TIMER			(0x250)
#define TOMTOM_A_CDC_TX7_VOL_CTL_TIMER__POR				(0x00)
#define TOMTOM_A_CDC_TX8_VOL_CTL_TIMER			(0x258)
#define TOMTOM_A_CDC_TX8_VOL_CTL_TIMER__POR				(0x00)
#define TOMTOM_A_CDC_TX9_VOL_CTL_TIMER			(0x260)
#define TOMTOM_A_CDC_TX9_VOL_CTL_TIMER__POR				(0x00)
#define TOMTOM_A_CDC_TX10_VOL_CTL_TIMER			(0x268)
#define TOMTOM_A_CDC_TX10_VOL_CTL_TIMER__POR				(0x00)
#define TOMTOM_A_CDC_TX1_VOL_CTL_GAIN			(0x221)
#define TOMTOM_A_CDC_TX1_VOL_CTL_GAIN__POR				(0x00)
#define TOMTOM_A_CDC_TX2_VOL_CTL_GAIN			(0x229)
#define TOMTOM_A_CDC_TX2_VOL_CTL_GAIN__POR				(0x00)
#define TOMTOM_A_CDC_TX3_VOL_CTL_GAIN			(0x231)
#define TOMTOM_A_CDC_TX3_VOL_CTL_GAIN__POR				(0x00)
#define TOMTOM_A_CDC_TX4_VOL_CTL_GAIN			(0x239)
#define TOMTOM_A_CDC_TX4_VOL_CTL_GAIN__POR				(0x00)
#define TOMTOM_A_CDC_TX5_VOL_CTL_GAIN			(0x241)
#define TOMTOM_A_CDC_TX5_VOL_CTL_GAIN__POR				(0x00)
#define TOMTOM_A_CDC_TX6_VOL_CTL_GAIN			(0x249)
#define TOMTOM_A_CDC_TX6_VOL_CTL_GAIN__POR				(0x00)
#define TOMTOM_A_CDC_TX7_VOL_CTL_GAIN			(0x251)
#define TOMTOM_A_CDC_TX7_VOL_CTL_GAIN__POR				(0x00)
#define TOMTOM_A_CDC_TX8_VOL_CTL_GAIN			(0x259)
#define TOMTOM_A_CDC_TX8_VOL_CTL_GAIN__POR				(0x00)
#define TOMTOM_A_CDC_TX9_VOL_CTL_GAIN			(0x261)
#define TOMTOM_A_CDC_TX9_VOL_CTL_GAIN__POR				(0x00)
#define TOMTOM_A_CDC_TX10_VOL_CTL_GAIN			(0x269)
#define TOMTOM_A_CDC_TX10_VOL_CTL_GAIN__POR				(0x00)
#define TOMTOM_A_CDC_TX1_VOL_CTL_CFG			(0x222)
#define TOMTOM_A_CDC_TX1_VOL_CTL_CFG__POR				(0x00)
#define TOMTOM_A_CDC_TX2_VOL_CTL_CFG			(0x22A)
#define TOMTOM_A_CDC_TX2_VOL_CTL_CFG__POR				(0x00)
#define TOMTOM_A_CDC_TX3_VOL_CTL_CFG			(0x232)
#define TOMTOM_A_CDC_TX3_VOL_CTL_CFG__POR				(0x00)
#define TOMTOM_A_CDC_TX4_VOL_CTL_CFG			(0x23A)
#define TOMTOM_A_CDC_TX4_VOL_CTL_CFG__POR				(0x00)
#define TOMTOM_A_CDC_TX5_VOL_CTL_CFG			(0x242)
#define TOMTOM_A_CDC_TX5_VOL_CTL_CFG__POR				(0x00)
#define TOMTOM_A_CDC_TX6_VOL_CTL_CFG			(0x24A)
#define TOMTOM_A_CDC_TX6_VOL_CTL_CFG__POR				(0x00)
#define TOMTOM_A_CDC_TX7_VOL_CTL_CFG			(0x252)
#define TOMTOM_A_CDC_TX7_VOL_CTL_CFG__POR				(0x00)
#define TOMTOM_A_CDC_TX8_VOL_CTL_CFG			(0x25A)
#define TOMTOM_A_CDC_TX8_VOL_CTL_CFG__POR				(0x00)
#define TOMTOM_A_CDC_TX9_VOL_CTL_CFG			(0x262)
#define TOMTOM_A_CDC_TX9_VOL_CTL_CFG__POR				(0x00)
#define TOMTOM_A_CDC_TX10_VOL_CTL_CFG			(0x26A)
#define TOMTOM_A_CDC_TX10_VOL_CTL_CFG__POR				(0x00)
#define TOMTOM_A_CDC_TX1_MUX_CTL			(0x223)
#define TOMTOM_A_CDC_TX1_MUX_CTL__POR				(0x48)
#define TOMTOM_A_CDC_TX2_MUX_CTL			(0x22B)
#define TOMTOM_A_CDC_TX2_MUX_CTL__POR				(0x48)
#define TOMTOM_A_CDC_TX3_MUX_CTL			(0x233)
#define TOMTOM_A_CDC_TX3_MUX_CTL__POR				(0x48)
#define TOMTOM_A_CDC_TX4_MUX_CTL			(0x23B)
#define TOMTOM_A_CDC_TX4_MUX_CTL__POR				(0x48)
#define TOMTOM_A_CDC_TX5_MUX_CTL			(0x243)
#define TOMTOM_A_CDC_TX5_MUX_CTL__POR				(0x48)
#define TOMTOM_A_CDC_TX6_MUX_CTL			(0x24B)
#define TOMTOM_A_CDC_TX6_MUX_CTL__POR				(0x48)
#define TOMTOM_A_CDC_TX7_MUX_CTL			(0x253)
#define TOMTOM_A_CDC_TX7_MUX_CTL__POR				(0x48)
#define TOMTOM_A_CDC_TX8_MUX_CTL			(0x25B)
#define TOMTOM_A_CDC_TX8_MUX_CTL__POR				(0x48)
#define TOMTOM_A_CDC_TX9_MUX_CTL			(0x263)
#define TOMTOM_A_CDC_TX9_MUX_CTL__POR				(0x48)
#define TOMTOM_A_CDC_TX10_MUX_CTL			(0x26B)
#define TOMTOM_A_CDC_TX10_MUX_CTL__POR				(0x48)
#define TOMTOM_A_CDC_TX1_CLK_FS_CTL			(0x224)
#define TOMTOM_A_CDC_TX1_CLK_FS_CTL__POR				(0x03)
#define TOMTOM_A_CDC_TX2_CLK_FS_CTL			(0x22C)
#define TOMTOM_A_CDC_TX2_CLK_FS_CTL__POR				(0x03)
#define TOMTOM_A_CDC_TX3_CLK_FS_CTL			(0x234)
#define TOMTOM_A_CDC_TX3_CLK_FS_CTL__POR				(0x03)
#define TOMTOM_A_CDC_TX4_CLK_FS_CTL			(0x23C)
#define TOMTOM_A_CDC_TX4_CLK_FS_CTL__POR				(0x03)
#define TOMTOM_A_CDC_TX5_CLK_FS_CTL			(0x244)
#define TOMTOM_A_CDC_TX5_CLK_FS_CTL__POR				(0x03)
#define TOMTOM_A_CDC_TX6_CLK_FS_CTL			(0x24C)
#define TOMTOM_A_CDC_TX6_CLK_FS_CTL__POR				(0x03)
#define TOMTOM_A_CDC_TX7_CLK_FS_CTL			(0x254)
#define TOMTOM_A_CDC_TX7_CLK_FS_CTL__POR				(0x03)
#define TOMTOM_A_CDC_TX8_CLK_FS_CTL			(0x25C)
#define TOMTOM_A_CDC_TX8_CLK_FS_CTL__POR				(0x03)
#define TOMTOM_A_CDC_TX9_CLK_FS_CTL			(0x264)
#define TOMTOM_A_CDC_TX9_CLK_FS_CTL__POR				(0x03)
#define TOMTOM_A_CDC_TX10_CLK_FS_CTL			(0x26C)
#define TOMTOM_A_CDC_TX10_CLK_FS_CTL__POR				(0x03)
#define TOMTOM_A_CDC_TX1_DMIC_CTL			(0x225)
#define TOMTOM_A_CDC_TX1_DMIC_CTL__POR				(0x00)
#define TOMTOM_A_CDC_TX2_DMIC_CTL			(0x22D)
#define TOMTOM_A_CDC_TX2_DMIC_CTL__POR				(0x00)
#define TOMTOM_A_CDC_TX3_DMIC_CTL			(0x235)
#define TOMTOM_A_CDC_TX3_DMIC_CTL__POR				(0x00)
#define TOMTOM_A_CDC_TX4_DMIC_CTL			(0x23D)
#define TOMTOM_A_CDC_TX4_DMIC_CTL__POR				(0x00)
#define TOMTOM_A_CDC_TX5_DMIC_CTL			(0x245)
#define TOMTOM_A_CDC_TX5_DMIC_CTL__POR				(0x00)
#define TOMTOM_A_CDC_TX6_DMIC_CTL			(0x24D)
#define TOMTOM_A_CDC_TX6_DMIC_CTL__POR				(0x00)
#define TOMTOM_A_CDC_TX7_DMIC_CTL			(0x255)
#define TOMTOM_A_CDC_TX7_DMIC_CTL__POR				(0x00)
#define TOMTOM_A_CDC_TX8_DMIC_CTL			(0x25D)
#define TOMTOM_A_CDC_TX8_DMIC_CTL__POR				(0x00)
#define TOMTOM_A_CDC_TX9_DMIC_CTL			(0x265)
#define TOMTOM_A_CDC_TX9_DMIC_CTL__POR				(0x00)
#define TOMTOM_A_CDC_TX10_DMIC_CTL			(0x26D)
#define TOMTOM_A_CDC_TX10_DMIC_CTL__POR				(0x00)
#define TOMTOM_A_CDC_SPKR_CLIPDET_VAL0			(0x270)
#define TOMTOM_A_CDC_SPKR_CLIPDET_VAL0__POR				(0x00)
#define TOMTOM_A_CDC_SPKR_CLIPDET_VAL1			(0x271)
#define TOMTOM_A_CDC_SPKR_CLIPDET_VAL1__POR				(0x00)
#define TOMTOM_A_CDC_SPKR_CLIPDET_VAL2			(0x272)
#define TOMTOM_A_CDC_SPKR_CLIPDET_VAL2__POR				(0x00)
#define TOMTOM_A_CDC_SPKR_CLIPDET_VAL3			(0x273)
#define TOMTOM_A_CDC_SPKR_CLIPDET_VAL3__POR				(0x00)
#define TOMTOM_A_CDC_SPKR_CLIPDET_VAL4			(0x274)
#define TOMTOM_A_CDC_SPKR_CLIPDET_VAL4__POR				(0x00)
#define TOMTOM_A_CDC_SPKR_CLIPDET_VAL5			(0x275)
#define TOMTOM_A_CDC_SPKR_CLIPDET_VAL5__POR				(0x00)
#define TOMTOM_A_CDC_SPKR_CLIPDET_VAL6			(0x276)
#define TOMTOM_A_CDC_SPKR_CLIPDET_VAL6__POR				(0x00)
#define TOMTOM_A_CDC_SPKR_CLIPDET_VAL7			(0x277)
#define TOMTOM_A_CDC_SPKR_CLIPDET_VAL7__POR				(0x00)
#define TOMTOM_A_CDC_DEBUG_B1_CTL			(0x278)
#define TOMTOM_A_CDC_DEBUG_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_DEBUG_B2_CTL			(0x279)
#define TOMTOM_A_CDC_DEBUG_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_DEBUG_B3_CTL			(0x27A)
#define TOMTOM_A_CDC_DEBUG_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_DEBUG_B4_CTL			(0x27B)
#define TOMTOM_A_CDC_DEBUG_B4_CTL__POR				(0x00)
#define TOMTOM_A_CDC_DEBUG_B5_CTL			(0x27C)
#define TOMTOM_A_CDC_DEBUG_B5_CTL__POR				(0x00)
#define TOMTOM_A_CDC_DEBUG_B6_CTL			(0x27D)
#define TOMTOM_A_CDC_DEBUG_B6_CTL__POR				(0x00)
#define TOMTOM_A_CDC_DEBUG_B7_CTL			(0x27E)
#define TOMTOM_A_CDC_DEBUG_B7_CTL__POR				(0x00)
#define TOMTOM_A_CDC_SRC1_PDA_CFG			(0x2A0)
#define TOMTOM_A_CDC_SRC1_PDA_CFG__POR				(0x00)
#define TOMTOM_A_CDC_SRC2_PDA_CFG			(0x2A8)
#define TOMTOM_A_CDC_SRC2_PDA_CFG__POR				(0x00)
#define TOMTOM_A_CDC_SRC1_FS_CTL			(0x2A1)
#define TOMTOM_A_CDC_SRC1_FS_CTL__POR				(0x1B)
#define TOMTOM_A_CDC_SRC2_FS_CTL			(0x2A9)
#define TOMTOM_A_CDC_SRC2_FS_CTL__POR				(0x1B)
#define TOMTOM_A_CDC_RX1_B1_CTL			(0x2B0)
#define TOMTOM_A_CDC_RX1_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX2_B1_CTL			(0x2B8)
#define TOMTOM_A_CDC_RX2_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX3_B1_CTL			(0x2C0)
#define TOMTOM_A_CDC_RX3_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX4_B1_CTL			(0x2C8)
#define TOMTOM_A_CDC_RX4_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX5_B1_CTL			(0x2D0)
#define TOMTOM_A_CDC_RX5_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX6_B1_CTL			(0x2D8)
#define TOMTOM_A_CDC_RX6_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX7_B1_CTL			(0x2E0)
#define TOMTOM_A_CDC_RX7_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX1_B2_CTL			(0x2B1)
#define TOMTOM_A_CDC_RX1_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX2_B2_CTL			(0x2B9)
#define TOMTOM_A_CDC_RX2_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX3_B2_CTL			(0x2C1)
#define TOMTOM_A_CDC_RX3_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX4_B2_CTL			(0x2C9)
#define TOMTOM_A_CDC_RX4_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX5_B2_CTL			(0x2D1)
#define TOMTOM_A_CDC_RX5_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX6_B2_CTL			(0x2D9)
#define TOMTOM_A_CDC_RX6_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX7_B2_CTL			(0x2E1)
#define TOMTOM_A_CDC_RX7_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX1_B3_CTL			(0x2B2)
#define TOMTOM_A_CDC_RX1_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX2_B3_CTL			(0x2BA)
#define TOMTOM_A_CDC_RX2_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX3_B3_CTL			(0x2C2)
#define TOMTOM_A_CDC_RX3_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX4_B3_CTL			(0x2CA)
#define TOMTOM_A_CDC_RX4_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX5_B3_CTL			(0x2D2)
#define TOMTOM_A_CDC_RX5_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX6_B3_CTL			(0x2DA)
#define TOMTOM_A_CDC_RX6_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX7_B3_CTL			(0x2E2)
#define TOMTOM_A_CDC_RX7_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX1_B4_CTL			(0x2B3)
#define TOMTOM_A_CDC_RX1_B4_CTL__POR				(0x0B)
#define TOMTOM_A_CDC_RX2_B4_CTL			(0x2BB)
#define TOMTOM_A_CDC_RX2_B4_CTL__POR				(0x0B)
#define TOMTOM_A_CDC_RX3_B4_CTL			(0x2C3)
#define TOMTOM_A_CDC_RX3_B4_CTL__POR				(0x0B)
#define TOMTOM_A_CDC_RX4_B4_CTL			(0x2CB)
#define TOMTOM_A_CDC_RX4_B4_CTL__POR				(0x0B)
#define TOMTOM_A_CDC_RX5_B4_CTL			(0x2D3)
#define TOMTOM_A_CDC_RX5_B4_CTL__POR				(0x0B)
#define TOMTOM_A_CDC_RX6_B4_CTL			(0x2DB)
#define TOMTOM_A_CDC_RX6_B4_CTL__POR				(0x0B)
#define TOMTOM_A_CDC_RX7_B4_CTL			(0x2E3)
#define TOMTOM_A_CDC_RX7_B4_CTL__POR				(0x0B)
#define TOMTOM_A_CDC_RX1_B5_CTL			(0x2B4)
#define TOMTOM_A_CDC_RX1_B5_CTL__POR				(0x78)
#define TOMTOM_A_CDC_RX2_B5_CTL			(0x2BC)
#define TOMTOM_A_CDC_RX2_B5_CTL__POR				(0x78)
#define TOMTOM_A_CDC_RX3_B5_CTL			(0x2C4)
#define TOMTOM_A_CDC_RX3_B5_CTL__POR				(0x78)
#define TOMTOM_A_CDC_RX4_B5_CTL			(0x2CC)
#define TOMTOM_A_CDC_RX4_B5_CTL__POR				(0x78)
#define TOMTOM_A_CDC_RX5_B5_CTL			(0x2D4)
#define TOMTOM_A_CDC_RX5_B5_CTL__POR				(0x78)
#define TOMTOM_A_CDC_RX6_B5_CTL			(0x2DC)
#define TOMTOM_A_CDC_RX6_B5_CTL__POR				(0x78)
#define TOMTOM_A_CDC_RX7_B5_CTL			(0x2E4)
#define TOMTOM_A_CDC_RX7_B5_CTL__POR				(0x78)
#define TOMTOM_A_CDC_RX1_B6_CTL			(0x2B5)
#define TOMTOM_A_CDC_RX1_B6_CTL__POR				(0x80)
#define TOMTOM_A_CDC_RX2_B6_CTL			(0x2BD)
#define TOMTOM_A_CDC_RX2_B6_CTL__POR				(0x80)
#define TOMTOM_A_CDC_RX3_B6_CTL			(0x2C5)
#define TOMTOM_A_CDC_RX3_B6_CTL__POR				(0x80)
#define TOMTOM_A_CDC_RX4_B6_CTL			(0x2CD)
#define TOMTOM_A_CDC_RX4_B6_CTL__POR				(0x80)
#define TOMTOM_A_CDC_RX5_B6_CTL			(0x2D5)
#define TOMTOM_A_CDC_RX5_B6_CTL__POR				(0x80)
#define TOMTOM_A_CDC_RX6_B6_CTL			(0x2DD)
#define TOMTOM_A_CDC_RX6_B6_CTL__POR				(0x80)
#define TOMTOM_A_CDC_RX7_B6_CTL			(0x2E5)
#define TOMTOM_A_CDC_RX7_B6_CTL__POR				(0x80)
#define TOMTOM_A_CDC_RX1_VOL_CTL_B1_CTL			(0x2B6)
#define TOMTOM_A_CDC_RX1_VOL_CTL_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX2_VOL_CTL_B1_CTL			(0x2BE)
#define TOMTOM_A_CDC_RX2_VOL_CTL_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX3_VOL_CTL_B1_CTL			(0x2C6)
#define TOMTOM_A_CDC_RX3_VOL_CTL_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX4_VOL_CTL_B1_CTL			(0x2CE)
#define TOMTOM_A_CDC_RX4_VOL_CTL_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX5_VOL_CTL_B1_CTL			(0x2D6)
#define TOMTOM_A_CDC_RX5_VOL_CTL_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX6_VOL_CTL_B1_CTL			(0x2DE)
#define TOMTOM_A_CDC_RX6_VOL_CTL_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX7_VOL_CTL_B1_CTL			(0x2E6)
#define TOMTOM_A_CDC_RX7_VOL_CTL_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX1_VOL_CTL_B2_CTL			(0x2B7)
#define TOMTOM_A_CDC_RX1_VOL_CTL_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX2_VOL_CTL_B2_CTL			(0x2BF)
#define TOMTOM_A_CDC_RX2_VOL_CTL_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX3_VOL_CTL_B2_CTL			(0x2C7)
#define TOMTOM_A_CDC_RX3_VOL_CTL_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX4_VOL_CTL_B2_CTL			(0x2CF)
#define TOMTOM_A_CDC_RX4_VOL_CTL_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX5_VOL_CTL_B2_CTL			(0x2D7)
#define TOMTOM_A_CDC_RX5_VOL_CTL_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX6_VOL_CTL_B2_CTL			(0x2DF)
#define TOMTOM_A_CDC_RX6_VOL_CTL_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX7_VOL_CTL_B2_CTL			(0x2E7)
#define TOMTOM_A_CDC_RX7_VOL_CTL_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_VBAT_CFG			(0x2E8)
#define TOMTOM_A_CDC_VBAT_CFG__POR				(0x1A)
#define TOMTOM_A_CDC_VBAT_ADC_CAL1			(0x2E9)
#define TOMTOM_A_CDC_VBAT_ADC_CAL1__POR				(0x00)
#define TOMTOM_A_CDC_VBAT_ADC_CAL2			(0x2EA)
#define TOMTOM_A_CDC_VBAT_ADC_CAL2__POR				(0x00)
#define TOMTOM_A_CDC_VBAT_ADC_CAL3			(0x2EB)
#define TOMTOM_A_CDC_VBAT_ADC_CAL3__POR				(0x04)
#define TOMTOM_A_CDC_VBAT_PK_EST1			(0x2EC)
#define TOMTOM_A_CDC_VBAT_PK_EST1__POR				(0xE0)
#define TOMTOM_A_CDC_VBAT_PK_EST2			(0x2ED)
#define TOMTOM_A_CDC_VBAT_PK_EST2__POR				(0x01)
#define TOMTOM_A_CDC_VBAT_PK_EST3			(0x2EE)
#define TOMTOM_A_CDC_VBAT_PK_EST3__POR				(0x40)
#define TOMTOM_A_CDC_VBAT_RF_PROC1			(0x2EF)
#define TOMTOM_A_CDC_VBAT_RF_PROC1__POR				(0x2A)
#define TOMTOM_A_CDC_VBAT_RF_PROC2			(0x2F0)
#define TOMTOM_A_CDC_VBAT_RF_PROC2__POR				(0x86)
#define TOMTOM_A_CDC_VBAT_TAC1			(0x2F1)
#define TOMTOM_A_CDC_VBAT_TAC1__POR				(0x70)
#define TOMTOM_A_CDC_VBAT_TAC2			(0x2F2)
#define TOMTOM_A_CDC_VBAT_TAC2__POR				(0x18)
#define TOMTOM_A_CDC_VBAT_TAC3			(0x2F3)
#define TOMTOM_A_CDC_VBAT_TAC3__POR				(0x18)
#define TOMTOM_A_CDC_VBAT_TAC4			(0x2F4)
#define TOMTOM_A_CDC_VBAT_TAC4__POR				(0x03)
#define TOMTOM_A_CDC_VBAT_GAIN_UPD1			(0x2F5)
#define TOMTOM_A_CDC_VBAT_GAIN_UPD1__POR				(0x01)
#define TOMTOM_A_CDC_VBAT_GAIN_UPD2			(0x2F6)
#define TOMTOM_A_CDC_VBAT_GAIN_UPD2__POR				(0x00)
#define TOMTOM_A_CDC_VBAT_GAIN_UPD3			(0x2F7)
#define TOMTOM_A_CDC_VBAT_GAIN_UPD3__POR				(0x64)
#define TOMTOM_A_CDC_VBAT_GAIN_UPD4			(0x2F8)
#define TOMTOM_A_CDC_VBAT_GAIN_UPD4__POR				(0x01)
#define TOMTOM_A_CDC_VBAT_DEBUG1			(0x2F9)
#define TOMTOM_A_CDC_VBAT_DEBUG1__POR				(0x00)
#define TOMTOM_A_CDC_VBAT_GAIN_UPD_MON			(0x2FA)
#define TOMTOM_A_CDC_VBAT_GAIN_UPD_MON__POR				(0x00)
#define TOMTOM_A_CDC_VBAT_GAIN_MON_VAL			(0x2FB)
#define TOMTOM_A_CDC_VBAT_GAIN_MON_VAL__POR				(0x00)
#define TOMTOM_A_CDC_CLK_ANC_RESET_CTL			(0x300)
#define TOMTOM_A_CDC_CLK_ANC_RESET_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CLK_RX_RESET_CTL			(0x301)
#define TOMTOM_A_CDC_CLK_RX_RESET_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CLK_TX_RESET_B1_CTL			(0x302)
#define TOMTOM_A_CDC_CLK_TX_RESET_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CLK_TX_RESET_B2_CTL			(0x303)
#define TOMTOM_A_CDC_CLK_TX_RESET_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CLK_RX_I2S_CTL			(0x306)
#define TOMTOM_A_CDC_CLK_RX_I2S_CTL__POR				(0x03)
#define TOMTOM_A_CDC_CLK_TX_I2S_CTL			(0x307)
#define TOMTOM_A_CDC_CLK_TX_I2S_CTL__POR				(0x03)
#define TOMTOM_A_CDC_CLK_OTHR_RESET_B1_CTL			(0x308)
#define TOMTOM_A_CDC_CLK_OTHR_RESET_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CLK_OTHR_RESET_B2_CTL			(0x309)
#define TOMTOM_A_CDC_CLK_OTHR_RESET_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CLK_TX_CLK_EN_B1_CTL			(0x30A)
#define TOMTOM_A_CDC_CLK_TX_CLK_EN_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CLK_TX_CLK_EN_B2_CTL			(0x30B)
#define TOMTOM_A_CDC_CLK_TX_CLK_EN_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CLK_OTHR_CTL			(0x30C)
#define TOMTOM_A_CDC_CLK_OTHR_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CLK_ANC_CLK_EN_CTL			(0x30E)
#define TOMTOM_A_CDC_CLK_ANC_CLK_EN_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CLK_RX_B1_CTL			(0x30F)
#define TOMTOM_A_CDC_CLK_RX_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CLK_RX_B2_CTL			(0x310)
#define TOMTOM_A_CDC_CLK_RX_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CLK_MCLK_CTL			(0x311)
#define TOMTOM_A_CDC_CLK_MCLK_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CLK_PDM_CTL			(0x312)
#define TOMTOM_A_CDC_CLK_PDM_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CLK_SD_CTL			(0x313)
#define TOMTOM_A_CDC_CLK_SD_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CLSH_B1_CTL			(0x320)
#define TOMTOM_A_CDC_CLSH_B1_CTL__POR				(0xE4)
#define TOMTOM_A_CDC_CLSH_B2_CTL			(0x321)
#define TOMTOM_A_CDC_CLSH_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CLSH_B3_CTL			(0x322)
#define TOMTOM_A_CDC_CLSH_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CLSH_BUCK_NCP_VARS			(0x323)
#define TOMTOM_A_CDC_CLSH_BUCK_NCP_VARS__POR				(0x00)
#define TOMTOM_A_CDC_CLSH_IDLE_HPH_THSD			(0x324)
#define TOMTOM_A_CDC_CLSH_IDLE_HPH_THSD__POR				(0x12)
#define TOMTOM_A_CDC_CLSH_IDLE_EAR_THSD			(0x325)
#define TOMTOM_A_CDC_CLSH_IDLE_EAR_THSD__POR				(0x0C)
#define TOMTOM_A_CDC_CLSH_FCLKONLY_HPH_THSD			(0x326)
#define TOMTOM_A_CDC_CLSH_FCLKONLY_HPH_THSD__POR			(0x18)
#define TOMTOM_A_CDC_CLSH_FCLKONLY_EAR_THSD			(0x327)
#define TOMTOM_A_CDC_CLSH_FCLKONLY_EAR_THSD__POR			(0x23)
#define TOMTOM_A_CDC_CLSH_K_ADDR			(0x328)
#define TOMTOM_A_CDC_CLSH_K_ADDR__POR				(0x00)
#define TOMTOM_A_CDC_CLSH_K_DATA			(0x329)
#define TOMTOM_A_CDC_CLSH_K_DATA__POR				(0xA4)
#define TOMTOM_A_CDC_CLSH_I_PA_FACT_HPH_L			(0x32A)
#define TOMTOM_A_CDC_CLSH_I_PA_FACT_HPH_L__POR				(0xD7)
#define TOMTOM_A_CDC_CLSH_I_PA_FACT_HPH_U			(0x32B)
#define TOMTOM_A_CDC_CLSH_I_PA_FACT_HPH_U__POR				(0x05)
#define TOMTOM_A_CDC_CLSH_I_PA_FACT_EAR_L			(0x32C)
#define TOMTOM_A_CDC_CLSH_I_PA_FACT_EAR_L__POR				(0x60)
#define TOMTOM_A_CDC_CLSH_I_PA_FACT_EAR_U			(0x32D)
#define TOMTOM_A_CDC_CLSH_I_PA_FACT_EAR_U__POR				(0x09)
#define TOMTOM_A_CDC_CLSH_V_PA_HD_EAR			(0x32E)
#define TOMTOM_A_CDC_CLSH_V_PA_HD_EAR__POR				(0x00)
#define TOMTOM_A_CDC_CLSH_V_PA_HD_HPH			(0x32F)
#define TOMTOM_A_CDC_CLSH_V_PA_HD_HPH__POR				(0x00)
#define TOMTOM_A_CDC_CLSH_V_PA_MIN_EAR			(0x330)
#define TOMTOM_A_CDC_CLSH_V_PA_MIN_EAR__POR				(0x00)
#define TOMTOM_A_CDC_CLSH_V_PA_MIN_HPH			(0x331)
#define TOMTOM_A_CDC_CLSH_V_PA_MIN_HPH__POR				(0x00)
#define TOMTOM_A_CDC_IIR1_GAIN_B1_CTL			(0x340)
#define TOMTOM_A_CDC_IIR1_GAIN_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_IIR2_GAIN_B1_CTL			(0x350)
#define TOMTOM_A_CDC_IIR2_GAIN_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_IIR1_GAIN_B2_CTL			(0x341)
#define TOMTOM_A_CDC_IIR1_GAIN_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_IIR2_GAIN_B2_CTL			(0x351)
#define TOMTOM_A_CDC_IIR2_GAIN_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_IIR1_GAIN_B3_CTL			(0x342)
#define TOMTOM_A_CDC_IIR1_GAIN_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_IIR2_GAIN_B3_CTL			(0x352)
#define TOMTOM_A_CDC_IIR2_GAIN_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_IIR1_GAIN_B4_CTL			(0x343)
#define TOMTOM_A_CDC_IIR1_GAIN_B4_CTL__POR				(0x00)
#define TOMTOM_A_CDC_IIR2_GAIN_B4_CTL			(0x353)
#define TOMTOM_A_CDC_IIR2_GAIN_B4_CTL__POR				(0x00)
#define TOMTOM_A_CDC_IIR1_GAIN_B5_CTL			(0x344)
#define TOMTOM_A_CDC_IIR1_GAIN_B5_CTL__POR				(0x00)
#define TOMTOM_A_CDC_IIR2_GAIN_B5_CTL			(0x354)
#define TOMTOM_A_CDC_IIR2_GAIN_B5_CTL__POR				(0x00)
#define TOMTOM_A_CDC_IIR1_GAIN_B6_CTL			(0x345)
#define TOMTOM_A_CDC_IIR1_GAIN_B6_CTL__POR				(0x00)
#define TOMTOM_A_CDC_IIR2_GAIN_B6_CTL			(0x355)
#define TOMTOM_A_CDC_IIR2_GAIN_B6_CTL__POR				(0x00)
#define TOMTOM_A_CDC_IIR1_GAIN_B7_CTL			(0x346)
#define TOMTOM_A_CDC_IIR1_GAIN_B7_CTL__POR				(0x00)
#define TOMTOM_A_CDC_IIR2_GAIN_B7_CTL			(0x356)
#define TOMTOM_A_CDC_IIR2_GAIN_B7_CTL__POR				(0x00)
#define TOMTOM_A_CDC_IIR1_GAIN_B8_CTL			(0x347)
#define TOMTOM_A_CDC_IIR1_GAIN_B8_CTL__POR				(0x00)
#define TOMTOM_A_CDC_IIR2_GAIN_B8_CTL			(0x357)
#define TOMTOM_A_CDC_IIR2_GAIN_B8_CTL__POR				(0x00)
#define TOMTOM_A_CDC_IIR1_CTL			(0x348)
#define TOMTOM_A_CDC_IIR1_CTL__POR				(0x40)
#define TOMTOM_A_CDC_IIR2_CTL			(0x358)
#define TOMTOM_A_CDC_IIR2_CTL__POR				(0x40)
#define TOMTOM_A_CDC_IIR1_GAIN_TIMER_CTL			(0x349)
#define TOMTOM_A_CDC_IIR1_GAIN_TIMER_CTL__POR				(0x00)
#define TOMTOM_A_CDC_IIR2_GAIN_TIMER_CTL			(0x359)
#define TOMTOM_A_CDC_IIR2_GAIN_TIMER_CTL__POR				(0x00)
#define TOMTOM_A_CDC_IIR1_COEF_B1_CTL			(0x34A)
#define TOMTOM_A_CDC_IIR1_COEF_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_IIR2_COEF_B1_CTL			(0x35A)
#define TOMTOM_A_CDC_IIR2_COEF_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_IIR1_COEF_B2_CTL			(0x34B)
#define TOMTOM_A_CDC_IIR1_COEF_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_IIR2_COEF_B2_CTL			(0x35B)
#define TOMTOM_A_CDC_IIR2_COEF_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_TOP_GAIN_UPDATE			(0x360)
#define TOMTOM_A_CDC_TOP_GAIN_UPDATE__POR				(0x00)
#define TOMTOM_A_CDC_PA_RAMP_B1_CTL			(0x361)
#define TOMTOM_A_CDC_PA_RAMP_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_PA_RAMP_B2_CTL			(0x362)
#define TOMTOM_A_CDC_PA_RAMP_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_PA_RAMP_B3_CTL			(0x363)
#define TOMTOM_A_CDC_PA_RAMP_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_PA_RAMP_B4_CTL			(0x364)
#define TOMTOM_A_CDC_PA_RAMP_B4_CTL__POR				(0x00)
#define TOMTOM_A_CDC_SPKR_CLIPDET_B1_CTL			(0x365)
#define TOMTOM_A_CDC_SPKR_CLIPDET_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_SPKR2_CLIPDET_B1_CTL			(0x366)
#define TOMTOM_A_CDC_SPKR2_CLIPDET_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_COMP0_B1_CTL			(0x368)
#define TOMTOM_A_CDC_COMP0_B1_CTL__POR				(0x30)
#define TOMTOM_A_CDC_COMP1_B1_CTL			(0x370)
#define TOMTOM_A_CDC_COMP1_B1_CTL__POR				(0x30)
#define TOMTOM_A_CDC_COMP2_B1_CTL			(0x378)
#define TOMTOM_A_CDC_COMP2_B1_CTL__POR				(0x30)
#define TOMTOM_A_CDC_COMP0_B2_CTL			(0x369)
#define TOMTOM_A_CDC_COMP0_B2_CTL__POR				(0xB5)
#define TOMTOM_A_CDC_COMP1_B2_CTL			(0x371)
#define TOMTOM_A_CDC_COMP1_B2_CTL__POR				(0xB5)
#define TOMTOM_A_CDC_COMP2_B2_CTL			(0x379)
#define TOMTOM_A_CDC_COMP2_B2_CTL__POR				(0xB5)
#define TOMTOM_A_CDC_COMP0_B3_CTL			(0x36A)
#define TOMTOM_A_CDC_COMP0_B3_CTL__POR				(0x28)
#define TOMTOM_A_CDC_COMP1_B3_CTL			(0x372)
#define TOMTOM_A_CDC_COMP1_B3_CTL__POR				(0x28)
#define TOMTOM_A_CDC_COMP2_B3_CTL			(0x37A)
#define TOMTOM_A_CDC_COMP2_B3_CTL__POR				(0x28)
#define TOMTOM_A_CDC_COMP0_B4_CTL			(0x36B)
#define TOMTOM_A_CDC_COMP0_B4_CTL__POR				(0x37)
#define TOMTOM_A_CDC_COMP1_B4_CTL			(0x373)
#define TOMTOM_A_CDC_COMP1_B4_CTL__POR				(0x37)
#define TOMTOM_A_CDC_COMP2_B4_CTL			(0x37B)
#define TOMTOM_A_CDC_COMP2_B4_CTL__POR				(0x37)
#define TOMTOM_A_CDC_COMP0_B5_CTL			(0x36C)
#define TOMTOM_A_CDC_COMP0_B5_CTL__POR				(0x7F)
#define TOMTOM_A_CDC_COMP1_B5_CTL			(0x374)
#define TOMTOM_A_CDC_COMP1_B5_CTL__POR				(0x7F)
#define TOMTOM_A_CDC_COMP2_B5_CTL			(0x37C)
#define TOMTOM_A_CDC_COMP2_B5_CTL__POR				(0x7F)
#define TOMTOM_A_CDC_COMP0_B6_CTL			(0x36D)
#define TOMTOM_A_CDC_COMP0_B6_CTL__POR				(0x00)
#define TOMTOM_A_CDC_COMP1_B6_CTL			(0x375)
#define TOMTOM_A_CDC_COMP1_B6_CTL__POR				(0x00)
#define TOMTOM_A_CDC_COMP2_B6_CTL			(0x37D)
#define TOMTOM_A_CDC_COMP2_B6_CTL__POR				(0x00)
#define TOMTOM_A_CDC_COMP0_SHUT_DOWN_STATUS			(0x36E)
#define TOMTOM_A_CDC_COMP0_SHUT_DOWN_STATUS__POR			(0x03)
#define TOMTOM_A_CDC_COMP1_SHUT_DOWN_STATUS			(0x376)
#define TOMTOM_A_CDC_COMP1_SHUT_DOWN_STATUS__POR			(0x03)
#define TOMTOM_A_CDC_COMP2_SHUT_DOWN_STATUS			(0x37E)
#define TOMTOM_A_CDC_COMP2_SHUT_DOWN_STATUS__POR			(0x03)
#define TOMTOM_A_CDC_COMP0_FS_CFG			(0x36F)
#define TOMTOM_A_CDC_COMP0_FS_CFG__POR				(0x03)
#define TOMTOM_A_CDC_COMP1_FS_CFG			(0x377)
#define TOMTOM_A_CDC_COMP1_FS_CFG__POR				(0x03)
#define TOMTOM_A_CDC_COMP2_FS_CFG			(0x37F)
#define TOMTOM_A_CDC_COMP2_FS_CFG__POR				(0x03)
#define TOMTOM_A_CDC_CONN_RX1_B1_CTL			(0x380)
#define TOMTOM_A_CDC_CONN_RX1_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_RX1_B2_CTL			(0x381)
#define TOMTOM_A_CDC_CONN_RX1_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_RX1_B3_CTL			(0x382)
#define TOMTOM_A_CDC_CONN_RX1_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_RX2_B1_CTL			(0x383)
#define TOMTOM_A_CDC_CONN_RX2_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_RX2_B2_CTL			(0x384)
#define TOMTOM_A_CDC_CONN_RX2_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_RX2_B3_CTL			(0x385)
#define TOMTOM_A_CDC_CONN_RX2_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_RX3_B1_CTL			(0x386)
#define TOMTOM_A_CDC_CONN_RX3_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_RX3_B2_CTL			(0x387)
#define TOMTOM_A_CDC_CONN_RX3_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_RX4_B1_CTL			(0x388)
#define TOMTOM_A_CDC_CONN_RX4_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_RX4_B2_CTL			(0x389)
#define TOMTOM_A_CDC_CONN_RX4_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_RX5_B1_CTL			(0x38A)
#define TOMTOM_A_CDC_CONN_RX5_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_RX5_B2_CTL			(0x38B)
#define TOMTOM_A_CDC_CONN_RX5_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_RX6_B1_CTL			(0x38C)
#define TOMTOM_A_CDC_CONN_RX6_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_RX6_B2_CTL			(0x38D)
#define TOMTOM_A_CDC_CONN_RX6_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_RX7_B1_CTL			(0x38E)
#define TOMTOM_A_CDC_CONN_RX7_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_RX7_B2_CTL			(0x38F)
#define TOMTOM_A_CDC_CONN_RX7_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_RX7_B3_CTL			(0x390)
#define TOMTOM_A_CDC_CONN_RX7_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_ANC_B1_CTL			(0x391)
#define TOMTOM_A_CDC_CONN_ANC_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_ANC_B2_CTL			(0x392)
#define TOMTOM_A_CDC_CONN_ANC_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_TX_B1_CTL			(0x393)
#define TOMTOM_A_CDC_CONN_TX_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_TX_B2_CTL			(0x394)
#define TOMTOM_A_CDC_CONN_TX_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_TX_B3_CTL			(0x395)
#define TOMTOM_A_CDC_CONN_TX_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_TX_B4_CTL			(0x396)
#define TOMTOM_A_CDC_CONN_TX_B4_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_EQ1_B1_CTL			(0x397)
#define TOMTOM_A_CDC_CONN_EQ1_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_EQ1_B2_CTL			(0x398)
#define TOMTOM_A_CDC_CONN_EQ1_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_EQ1_B3_CTL			(0x399)
#define TOMTOM_A_CDC_CONN_EQ1_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_EQ1_B4_CTL			(0x39A)
#define TOMTOM_A_CDC_CONN_EQ1_B4_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_EQ2_B1_CTL			(0x39B)
#define TOMTOM_A_CDC_CONN_EQ2_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_EQ2_B2_CTL			(0x39C)
#define TOMTOM_A_CDC_CONN_EQ2_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_EQ2_B3_CTL			(0x39D)
#define TOMTOM_A_CDC_CONN_EQ2_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_EQ2_B4_CTL			(0x39E)
#define TOMTOM_A_CDC_CONN_EQ2_B4_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_SRC1_B1_CTL			(0x39F)
#define TOMTOM_A_CDC_CONN_SRC1_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_SRC1_B2_CTL			(0x3A0)
#define TOMTOM_A_CDC_CONN_SRC1_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_SRC2_B1_CTL			(0x3A1)
#define TOMTOM_A_CDC_CONN_SRC2_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_SRC2_B2_CTL			(0x3A2)
#define TOMTOM_A_CDC_CONN_SRC2_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_TX_SB_B1_CTL			(0x3A3)
#define TOMTOM_A_CDC_CONN_TX_SB_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_TX_SB_B2_CTL			(0x3A4)
#define TOMTOM_A_CDC_CONN_TX_SB_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_TX_SB_B3_CTL			(0x3A5)
#define TOMTOM_A_CDC_CONN_TX_SB_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_TX_SB_B4_CTL			(0x3A6)
#define TOMTOM_A_CDC_CONN_TX_SB_B4_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_TX_SB_B5_CTL			(0x3A7)
#define TOMTOM_A_CDC_CONN_TX_SB_B5_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_TX_SB_B6_CTL			(0x3A8)
#define TOMTOM_A_CDC_CONN_TX_SB_B6_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_TX_SB_B7_CTL			(0x3A9)
#define TOMTOM_A_CDC_CONN_TX_SB_B7_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_TX_SB_B8_CTL			(0x3AA)
#define TOMTOM_A_CDC_CONN_TX_SB_B8_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_TX_SB_B9_CTL			(0x3AB)
#define TOMTOM_A_CDC_CONN_TX_SB_B9_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_TX_SB_B10_CTL			(0x3AC)
#define TOMTOM_A_CDC_CONN_TX_SB_B10_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_TX_SB_B11_CTL			(0x3AD)
#define TOMTOM_A_CDC_CONN_TX_SB_B11_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_RX_SB_B1_CTL			(0x3AE)
#define TOMTOM_A_CDC_CONN_RX_SB_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_RX_SB_B2_CTL			(0x3AF)
#define TOMTOM_A_CDC_CONN_RX_SB_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_CLSH_CTL			(0x3B0)
#define TOMTOM_A_CDC_CONN_CLSH_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CONN_MISC			(0x3B1)
#define TOMTOM_A_CDC_CONN_MISC__POR				(0x01)
#define TOMTOM_A_CDC_CONN_RX8_B1_CTL			(0x3B3)
#define TOMTOM_A_CDC_CONN_RX8_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR_B1_CTL		(0x3B4)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR_B1_CTL__POR				(0x81)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR_CLIP_LEVEL_ADJUST	(0x3B5)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR_CLIP_LEVEL_ADJUST__POR		(0x00)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR_MIN_CLIP_THRESHOLD	(0x3B6)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR_MIN_CLIP_THRESHOLD__POR		(0xFF)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR_THRESHOLD_STATUS	(0x3B7)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR_THRESHOLD_STATUS__POR		(0x00)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR_SAMPLE_MARK		(0x3B8)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR_SAMPLE_MARK__POR			(0x04)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR_BOOST_GATING		(0x3B9)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR_BOOST_GATING__POR			(0x04)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR2_B1_CTL		(0x3BA)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR2_B1_CTL__POR				(0x81)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR2_CLIP_LEVEL_ADJUST	(0x3BB)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR2_CLIP_LEVEL_ADJUST__POR		(0x00)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR2_MIN_CLIP_THRESHOLD	(0x3BC)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR2_MIN_CLIP_THRESHOLD__POR		(0xFF)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR2_THRESHOLD_STATUS	(0x3BD)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR2_THRESHOLD_STATUS__POR		(0x00)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR2_SAMPLE_MARK		(0x3BE)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR2_SAMPLE_MARK__POR			(0x04)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR2_BOOST_GATING	(0x3BF)
#define TOMTOM_A_CDC_CLIP_ADJ_SPKR2_BOOST_GATING__POR			(0x04)
#define TOMTOM_A_CDC_MBHC_EN_CTL			(0x3C0)
#define TOMTOM_A_CDC_MBHC_EN_CTL__POR				(0x00)
#define TOMTOM_A_CDC_MBHC_FIR_B1_CFG			(0x3C1)
#define TOMTOM_A_CDC_MBHC_FIR_B1_CFG__POR				(0x00)
#define TOMTOM_A_CDC_MBHC_FIR_B2_CFG			(0x3C2)
#define TOMTOM_A_CDC_MBHC_FIR_B2_CFG__POR				(0x06)
#define TOMTOM_A_CDC_MBHC_TIMER_B1_CTL			(0x3C3)
#define TOMTOM_A_CDC_MBHC_TIMER_B1_CTL__POR				(0x03)
#define TOMTOM_A_CDC_MBHC_TIMER_B2_CTL			(0x3C4)
#define TOMTOM_A_CDC_MBHC_TIMER_B2_CTL__POR				(0x09)
#define TOMTOM_A_CDC_MBHC_TIMER_B3_CTL			(0x3C5)
#define TOMTOM_A_CDC_MBHC_TIMER_B3_CTL__POR				(0x1E)
#define TOMTOM_A_CDC_MBHC_TIMER_B4_CTL			(0x3C6)
#define TOMTOM_A_CDC_MBHC_TIMER_B4_CTL__POR				(0x45)
#define TOMTOM_A_CDC_MBHC_TIMER_B5_CTL			(0x3C7)
#define TOMTOM_A_CDC_MBHC_TIMER_B5_CTL__POR				(0x04)
#define TOMTOM_A_CDC_MBHC_TIMER_B6_CTL			(0x3C8)
#define TOMTOM_A_CDC_MBHC_TIMER_B6_CTL__POR				(0x78)
#define TOMTOM_A_CDC_MBHC_B1_STATUS			(0x3C9)
#define TOMTOM_A_CDC_MBHC_B1_STATUS__POR				(0x00)
#define TOMTOM_A_CDC_MBHC_B2_STATUS			(0x3CA)
#define TOMTOM_A_CDC_MBHC_B2_STATUS__POR				(0x00)
#define TOMTOM_A_CDC_MBHC_B3_STATUS			(0x3CB)
#define TOMTOM_A_CDC_MBHC_B3_STATUS__POR				(0x00)
#define TOMTOM_A_CDC_MBHC_B4_STATUS			(0x3CC)
#define TOMTOM_A_CDC_MBHC_B4_STATUS__POR				(0x00)
#define TOMTOM_A_CDC_MBHC_B5_STATUS			(0x3CD)
#define TOMTOM_A_CDC_MBHC_B5_STATUS__POR				(0x00)
#define TOMTOM_A_CDC_MBHC_B1_CTL			(0x3CE)
#define TOMTOM_A_CDC_MBHC_B1_CTL__POR				(0xC0)
#define TOMTOM_A_CDC_MBHC_B2_CTL			(0x3CF)
#define TOMTOM_A_CDC_MBHC_B2_CTL__POR				(0x5D)
#define TOMTOM_A_CDC_MBHC_VOLT_B1_CTL			(0x3D0)
#define TOMTOM_A_CDC_MBHC_VOLT_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_MBHC_VOLT_B2_CTL			(0x3D1)
#define TOMTOM_A_CDC_MBHC_VOLT_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_MBHC_VOLT_B3_CTL			(0x3D2)
#define TOMTOM_A_CDC_MBHC_VOLT_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_MBHC_VOLT_B4_CTL			(0x3D3)
#define TOMTOM_A_CDC_MBHC_VOLT_B4_CTL__POR				(0x00)
#define TOMTOM_A_CDC_MBHC_VOLT_B5_CTL			(0x3D4)
#define TOMTOM_A_CDC_MBHC_VOLT_B5_CTL__POR				(0x00)
#define TOMTOM_A_CDC_MBHC_VOLT_B6_CTL			(0x3D5)
#define TOMTOM_A_CDC_MBHC_VOLT_B6_CTL__POR				(0x00)
#define TOMTOM_A_CDC_MBHC_VOLT_B7_CTL			(0x3D6)
#define TOMTOM_A_CDC_MBHC_VOLT_B7_CTL__POR				(0xFF)
#define TOMTOM_A_CDC_MBHC_VOLT_B8_CTL			(0x3D7)
#define TOMTOM_A_CDC_MBHC_VOLT_B8_CTL__POR				(0x07)
#define TOMTOM_A_CDC_MBHC_VOLT_B9_CTL			(0x3D8)
#define TOMTOM_A_CDC_MBHC_VOLT_B9_CTL__POR				(0xFF)
#define TOMTOM_A_CDC_MBHC_VOLT_B10_CTL			(0x3D9)
#define TOMTOM_A_CDC_MBHC_VOLT_B10_CTL__POR				(0x7F)
#define TOMTOM_A_CDC_MBHC_VOLT_B11_CTL			(0x3DA)
#define TOMTOM_A_CDC_MBHC_VOLT_B11_CTL__POR				(0x00)
#define TOMTOM_A_CDC_MBHC_VOLT_B12_CTL			(0x3DB)
#define TOMTOM_A_CDC_MBHC_VOLT_B12_CTL__POR				(0x80)
#define TOMTOM_A_CDC_MBHC_CLK_CTL			(0x3DC)
#define TOMTOM_A_CDC_MBHC_CLK_CTL__POR				(0x00)
#define TOMTOM_A_CDC_MBHC_INT_CTL			(0x3DD)
#define TOMTOM_A_CDC_MBHC_INT_CTL__POR				(0x00)
#define TOMTOM_A_CDC_MBHC_DEBUG_CTL			(0x3DE)
#define TOMTOM_A_CDC_MBHC_DEBUG_CTL__POR				(0x00)
#define TOMTOM_A_CDC_MBHC_SPARE			(0x3DF)
#define TOMTOM_A_CDC_MBHC_SPARE__POR				(0x00)
#define TOMTOM_A_CDC_RX8_B1_CTL			(0x3E0)
#define TOMTOM_A_CDC_RX8_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX8_B2_CTL			(0x3E1)
#define TOMTOM_A_CDC_RX8_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX8_B3_CTL			(0x3E2)
#define TOMTOM_A_CDC_RX8_B3_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX8_B4_CTL			(0x3E3)
#define TOMTOM_A_CDC_RX8_B4_CTL__POR				(0x0B)
#define TOMTOM_A_CDC_RX8_B5_CTL			(0x3E4)
#define TOMTOM_A_CDC_RX8_B5_CTL__POR				(0x78)
#define TOMTOM_A_CDC_RX8_B6_CTL			(0x3E5)
#define TOMTOM_A_CDC_RX8_B6_CTL__POR				(0x80)
#define TOMTOM_A_CDC_RX8_VOL_CTL_B1_CTL			(0x3E6)
#define TOMTOM_A_CDC_RX8_VOL_CTL_B1_CTL__POR				(0x00)
#define TOMTOM_A_CDC_RX8_VOL_CTL_B2_CTL			(0x3E7)
#define TOMTOM_A_CDC_RX8_VOL_CTL_B2_CTL__POR				(0x00)
#define TOMTOM_A_CDC_SPKR2_CLIPDET_VAL0			(0x3E8)
#define TOMTOM_A_CDC_SPKR2_CLIPDET_VAL0__POR				(0x00)
#define TOMTOM_A_CDC_SPKR2_CLIPDET_VAL1			(0x3E9)
#define TOMTOM_A_CDC_SPKR2_CLIPDET_VAL1__POR				(0x00)
#define TOMTOM_A_CDC_SPKR2_CLIPDET_VAL2			(0x3EA)
#define TOMTOM_A_CDC_SPKR2_CLIPDET_VAL2__POR				(0x00)
#define TOMTOM_A_CDC_SPKR2_CLIPDET_VAL3			(0x3EB)
#define TOMTOM_A_CDC_SPKR2_CLIPDET_VAL3__POR				(0x00)
#define TOMTOM_A_CDC_SPKR2_CLIPDET_VAL4			(0x3EC)
#define TOMTOM_A_CDC_SPKR2_CLIPDET_VAL4__POR				(0x00)
#define TOMTOM_A_CDC_SPKR2_CLIPDET_VAL5			(0x3ED)
#define TOMTOM_A_CDC_SPKR2_CLIPDET_VAL5__POR				(0x00)
#define TOMTOM_A_CDC_SPKR2_CLIPDET_VAL6			(0x3EE)
#define TOMTOM_A_CDC_SPKR2_CLIPDET_VAL6__POR				(0x00)
#define TOMTOM_A_CDC_SPKR2_CLIPDET_VAL7			(0x3EF)
#define TOMTOM_A_CDC_SPKR2_CLIPDET_VAL7__POR				(0x00)
#define TOMTOM_A_CDC_BOOST_MODE_CTL			(0x3F0)
#define TOMTOM_A_CDC_BOOST_MODE_CTL__POR				(0x00)
#define TOMTOM_A_CDC_BOOST_THRESHOLD			(0x3F1)
#define TOMTOM_A_CDC_BOOST_THRESHOLD__POR				(0x02)
#define TOMTOM_A_CDC_BOOST_TAP_SEL			(0x3F2)
#define TOMTOM_A_CDC_BOOST_TAP_SEL__POR				(0x00)
#define TOMTOM_A_CDC_BOOST_HOLD_TIME			(0x3F3)
#define TOMTOM_A_CDC_BOOST_HOLD_TIME__POR				(0x02)
#define TOMTOM_A_CDC_BOOST_TRGR_EN			(0x3F4)
#define TOMTOM_A_CDC_BOOST_TRGR_EN__POR				(0x00)

/* SLIMBUS Slave Registers */
#define TOMTOM_SLIM_PGD_PORT_INT_EN0                     (0x30)
#define TOMTOM_SLIM_PGD_PORT_INT_STATUS_RX_0             (0x34)
#define TOMTOM_SLIM_PGD_PORT_INT_STATUS_RX_1             (0x35)
#define TOMTOM_SLIM_PGD_PORT_INT_STATUS_TX_0             (0x36)
#define TOMTOM_SLIM_PGD_PORT_INT_STATUS_TX_1             (0x37)
#define TOMTOM_SLIM_PGD_PORT_INT_CLR_RX_0                (0x38)
#define TOMTOM_SLIM_PGD_PORT_INT_CLR_RX_1                (0x39)
#define TOMTOM_SLIM_PGD_PORT_INT_CLR_TX_0                (0x3A)
#define TOMTOM_SLIM_PGD_PORT_INT_CLR_TX_1                (0x3B)
#define TOMTOM_SLIM_PGD_PORT_INT_RX_SOURCE0		(0x60)
#define TOMTOM_SLIM_PGD_PORT_INT_TX_SOURCE0		(0x70)

/* Macros for Packing Register Writes into a U32 */
#define TOMTOM_PACKED_REG_SIZE sizeof(u32)

#define TOMTOM_CODEC_PACK_ENTRY(reg, mask, val) ((val & 0xff)|\
	((mask & 0xff) << 8)|((reg & 0xffff) << 16))
#define TOMTOM_CODEC_UNPACK_ENTRY(packed, reg, mask, val) \
	do { \
		((reg) = ((packed >> 16) & (0xffff))); \
		((mask) = ((packed >> 8) & (0xff))); \
		((val) = ((packed) & (0xff))); \
	} while (0)

#define TOMTOM_SB_PGD_PORT_TX_BASE    0x50
#define TOMTOM_SB_PGD_PORT_RX_BASE    0x40
#define WCD9330_MAX_REGISTER 0x3FF
extern const u8 tomtom_reg_readable[WCD9330_MAX_REGISTER + 1];
#endif
