/*
This software is contributed or developed by KYOCERA Corporation.
(C) 2014 KYOCERA Corporation

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA. 

*/
#ifndef VGM_FLASH_IOCTL_H
#define VGM_FLASH_IOCTL_H
/*====*====*====*====*====*====*====*====*====*====*====*====*====*====*====*
                              <VGM_FLASH_IOCTL.H>
 DESCRIPTION
   Define ioctl command.

 Copyright (c) 2014 KYOCERA CORPORATION. All Rights Reserved.
*====*====*====*====*====*====*====*====*====*====*====*====*====*====*====*/

/*===========================================================================

                     INCLUDE FILES FOR MODULE

===========================================================================*/
#include <linux/ioctl.h>

/* --------------------------------------------------------------------------
** Constant / Define Declarations
** --------------------------------------------------------------------------
*/

/* --------------------------------------------------------------------------
** Type Declarations
** --------------------------------------------------------------------------
*/
/* definition of the argument of ioctl */
struct kc_read_info
{
    unsigned long       page_id;    /* read page number */
    unsigned char       *databuf;   /* main data storage domain address */
                                    /* Prepare a buffer of 4KB in caller */
    unsigned char       *metabuf;   /* meta data storage domain address */
    unsigned long       metalen;    /* meta data size */
};

struct kc_write_info
{
    unsigned long       page_id;    /* write page number */
    unsigned char       *databuf;   /* main data storage domain address */
                                    /* Prepare a buffer of 4KB in caller */
    unsigned char       *metabuf;   /* meta data storage domain address */
    unsigned long       metalen;    /* meta data size */
};

struct kc_erase_info
{
    unsigned long       block_id;   /* erase block number */
};

struct kc_is_erase_page_info
{
    unsigned long       page_id;    /* page number */
};

/* define ioctl commnad */
#define MEMREADPAGEKC       _IOWR('M', 50, struct kc_read_info)     /* read page with ECC */
#define MEMWRITEPAGEKC      _IOW('M', 51, struct kc_write_info)     /* write page with ECC */
#define MEMERASEKC          _IOW('M', 52, struct kc_erase_info)     /* block erase */
#define MEMGETBADBLOCKKC    _IOW('M', 53, unsigned long *)          /* bad block check */
#define MEMISERASEPAGEKC    _IOW('M', 54, struct kc_is_erase_page_info)     /* page erased check */
#define MEMWRITEANDMETAKC   _IOW('M', 55, struct kc_write_info)     /* write page & meta with ECC */
#define MEMREADANDMETAKC    _IOWR('M', 56, struct kc_read_info)     /* read page & meta with ECC */
#define MEMSETBADBLOCKKC    _IOW('M', 57, unsigned long *)          /* mark bad block */
#define MEMWAKEUPDRVKC      _IO('M', 58)                            /* wake up waiting address map update */
#define MEMRDAMSYMKC        _IOR('M', 59, unsigned long *)          /* get address map address */


/* --------------------------------------------------------------------------
** Local Object Definitions
** --------------------------------------------------------------------------
*/

/* ==========================================================================
**                        Function Definitions
** ========================================================================*/


#endif  /* VGM_FLASH_IOCTL_H */
