/*
 * kaudio_codec_distinction.c
 *
 * this program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 */
/*
 * This software is contributed or developed by KYOCERA Corporation.
 * (C) 2021 KYOCERA Corporation
 */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/spinlock.h>
#include <linux/gpio.h>
#include <linux/delay.h>
#include <linux/platform_device.h>

#define DISTINCTION_LOOP_MAX 3L
#define DISTINCTION_MAJORITY ((DISTINCTION_LOOP_MAX / 2L) + 1L)

#define DISTINCTION_VENDOR_AK 0UL
#define DISTINCTION_VENDOR_TI 1UL

static unsigned int manufacturer = DISTINCTION_VENDOR_AK;
module_param(manufacturer, uint, S_IRUGO | S_IWUSR);
MODULE_PARM_DESC(manufacturer, "Audio Codec IC Manufacturer");

static DEFINE_SPINLOCK(kacd_spin_lock);
static unsigned int acd_executed = 0UL;

int kaudio_codec_distinction (struct platform_device *pdev)
{
	int loop     = 0L;
	int ak       = 0L;
	int ti       = 0L;
	int id       = 0L;
	int gpio_val = 0L;
	unsigned long flags = 0UL;
	struct device_node *node = NULL;

	pr_info("%s [S]\n", __func__);

	spin_lock_irqsave(&kacd_spin_lock, flags);
	if (acd_executed == 0UL) {
		acd_executed = 1UL;
		for (loop = 0L; loop < DISTINCTION_LOOP_MAX; loop++) {
			gpio_val = gpio_get_value(21UL);
			if (gpio_val == 0L) {
				ti++;
			} else {
				ak++;
			}
			if (DISTINCTION_MAJORITY  <= ak) {
				manufacturer = DISTINCTION_VENDOR_AK;
				break;
			}
			if (DISTINCTION_MAJORITY  <= ti) {
				manufacturer = DISTINCTION_VENDOR_TI;
				break;
			}
			mdelay(10UL);
		}
	}
	spin_unlock_irqrestore(&kacd_spin_lock, flags);

	if (pdev != NULL) {
		node = pdev->dev.of_node;
		if (node != NULL) {
			id = of_alias_get_id(node, "spi");
			pr_info("%s: id=%d\n", __func__, id);
			if ((id == 6L) && (manufacturer == DISTINCTION_VENDOR_TI)) {
				pr_info("%s: [E] AudioCodecIC vendor is TI (spi:id=%d)\n", __func__, id);
				return -ENODEV;
			}
			id = of_alias_get_id(node, "i2c");
			pr_info("%s: id=%d\n", __func__, id);
			if ((id == 6L) && (manufacturer == DISTINCTION_VENDOR_AK)) {
				pr_info("%s: [E] AudioCodecIC vendor is AK (i2c:id=%d)\n", __func__, id);
				return -ENODEV;
			}
		}
	}

	pr_info("%s [E]\n", __func__);

	return 0;
}
EXPORT_SYMBOL(kaudio_codec_distinction);
