/*
 * pb_serial.c
 *
 * this program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 */
/*
 * This software is contributed or developed by KYOCERA Corporation.
 * (C) 2014 KYOCERA Corporation
 * (C) 2015 KYOCERA Corporation
 * (C) 2018 KYOCERA Corporation
 * (C) 2019 KYOCERA Corporation
 */
#include <linux/init.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/delay.h>

#include "pb_command.h"
#include "pb_serial.h"

int g_uart_print_level = MSG_INFO;
static int process_flag = 0;

void set_function_up(int id)
{
	process_flag = ((unsigned long)process_flag | (unsigned long)id);
}

static int __init pb_init(void)
{
	pb_print(MSG_DEBUG, "Entry\n");

	if (smd_setup() < 0) {
		pb_print(MSG_ERROR, "smd setting error\n");
		return -1;
	} else {
		pb_print(MSG_INFO, "SMD Section Ready\n");
	}
	pb_print(MSG_DEBUG, "Leave\n");
	return 0;
}

void __exit pb_exit(void)
{
	if (((unsigned long)process_flag & (unsigned long)SMD_SETTING) != 0L) {
		smd_stop();
	}
}
late_initcall(pb_init);

MODULE_LICENSE("GPL v2");
