/*
 * pb_command.h
 *
 * this program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 */
/*
 * This software is contributed or developed by KYOCERA Corporation.
 * (C) 2014 KYOCERA Corporation
 * (C) 2015 KYOCERA Corporation
 * (C) 2018 KYOCERA Corporation
 * (C) 2019 KYOCERA Corporation
 */

#ifndef __ARCH_ARM_MACH_MSM_PB_SERIAL_PB_COMMAND_H__
#define __ARCH_ARM_MACH_MSM_PB_SERIAL_PB_COMMAND_H__

#define PB_COMMAND_ALL_LEN	16
#define PB_CMD_BUFFER_SIZE	(PB_COMMAND_ALL_LEN * 2 + 1)

#if !defined FALSE
#define FALSE 0
#define TRUE !FALSE
#endif



typedef enum {
	PB_RESULT_OK			= 3010,
	PB_RESULT_NG			= 3020,
	PB_RESULT_UNKNOWN		= 3999,
	PB_ACTIVITY_ON			= 7010,
	PB_ACTIVITY_OFF			= 7020,
	PB_ACTIVITY_UNKNOWN		= 8999,
	PB_INVALID_PARAMETER	= 9999,
} pb_parm_id_type_e;

typedef pb_parm_id_type_e pb_line_type_e;
typedef pb_parm_id_type_e pb_result_type_e;
typedef pb_parm_id_type_e activity_type_e;

typedef enum {
	PB_USB_ACTIVITY_ID = 20,
	PB_UNKNOWN_COMMAND_ID = 9999
} pb_command_id_type_e;

typedef struct {
	activity_type_e activity;
} pb_usb_activity_cmd;

typedef struct {
	pb_command_id_type_e	id;
	union {
		pb_usb_activity_cmd			usba;
	} cmd;
} pb_command_universal;

pb_result_type_e pb_encode_command(const pb_command_universal *parm, char *cmd);

#endif /* __ARCH_ARM_MACH_MSM_PB_SERIAL_PB_COMMAND_H__ */
