/*
 * This software is contributed or developed by KYOCERA Corporation.
 * (C) 2016 KYOCERA Corporation
 * (C) 2018 KYOCERA Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __KAUDIO_API_H__
#define __KAUDIO_API_H__

#define KAUDIO_DEVICE_NAME "/dev/kaudio"

#if 0
enum {
	KAUDIO_IOCTL_GET_JACK_STATE = 1,
	KAUDIO_IOCTL_SET_SYSTEM_RESUME_TIMEOUT,
	KAUDIO_IOCTL_CODEC_CTRL,										/* AUD_06_0205 */ /* AUD_06_0244 */
};
#endif

typedef struct {
	unsigned int	value;
} kaudio_jack_state_t;

typedef struct {
	unsigned int	value;
} kaudio_system_resume_timeout_t;

/* AUD_06_0205:s */
typedef struct {
	unsigned int	cmd;
	unsigned int	prm1;
	unsigned int	prm2;
	unsigned int	prm3;										/* AUD_06_0242 */
} kaudio_codec_ctrl_t;											/* AUD_06_0244 */
/* AUD_06_0205:e */

typedef union {
	kaudio_jack_state_t				jack_state;
	kaudio_system_resume_timeout_t	system_resume_timeout;
	kaudio_codec_ctrl_t				codec_ctrl;					/* AUD_06_0205 */ /* AUD_06_0244 */
} kaudio_ioctl_t ;

#if 1
#define KAUDIO_IOC_MAGIC 'k'
#define KAUDIO_IOCTL_GET_JACK_STATE    _IOR(KAUDIO_IOC_MAGIC, 1, kaudio_jack_state_t)
#define KAUDIO_IOCTL_SET_SYSTEM_RESUME_TIMEOUT _IOW(KAUDIO_IOC_MAGIC, 2, kaudio_system_resume_timeout_t)
#define KAUDIO_IOCTL_CODEC_CTRL     _IOWR(KAUDIO_IOC_MAGIC, 3, kaudio_codec_ctrl_t)
#endif

#endif
