/*
 * This software is contributed or developed by KYOCERA Corporation.
 * (C) 2013 KYOCERA Corporation
 * (C) 2015 KYOCERA Corporation
 * (C) 2018 KYOCERA Corporation
 */
/* Copyright (c) 2010-2012, Code Aurora Forum. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <linux/kernel.h>
#include <linux/kc_board.h>
#include <soc/qcom/smsm.h>

static oem_board_type board_type = OEM_BOARD_FAIL_TYPE;
static oem_vendor_type vendor_type = OEM_VENDOR_FAIL_TYPE;

/* get hw id */
oem_board_type OEM_get_board(void)
{
  oem_board_type* phwid = NULL;

  if(board_type == OEM_BOARD_FAIL_TYPE)
  {
    phwid = (oem_board_type *) kc_smem_alloc( SMEM_HW_ID, 4);
    board_type = *phwid;
  }

  return(board_type);
}

/* get vendor cel */
oem_vendor_type OEM_get_vendor(void)
{
  oem_vendor_type* pvendor = NULL;
  if(vendor_type == OEM_VENDOR_FAIL_TYPE)
  {
    pvendor = (oem_vendor_type *) kc_smem_alloc ( SMEM_VENDOR_ID, 4);
    vendor_type = *pvendor;
  }

  return (vendor_type);
}
