/*
This software is contributed or developed by KYOCERA Corporation.
(C) 2014 KYOCERA Corporation
(C) 2016 KYOCERA Corporation
(C) 2018 KYOCERA Corporation
(C) 2019 KYOCERA Corporation
(C) 2020 KYOCERA Corporation

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA. 

*/
#ifndef VGM_H
#define VGM_H
/*====*====*====*====*====*====*====*====*====*====*====*====*====*====*====*
                              <VGM.H>
 DESCRIPTION
   VGM service main procedure header file

 Copyright (c) 2014 KYOCERA CORPORATION. All Rights Reserved.
*====*====*====*====*====*====*====*====*====*====*====*====*====*====*====*/

/*===========================================================================

                     INCLUDE FILES FOR MODULE

===========================================================================*/
#include "vgm_comdef.h"

/*===========================================================================

              DEFINITIONS AND DECLARATIONS FOR MODULE

===========================================================================*/
/* --------------------------------------------------------------------------
** Constant / Define Declarations
** --------------------------------------------------------------------------
*/
/* symbol name of the address map to share with an NAND driver */
#define VGM_ADDR_MAP_SYM        "vgm_flash_address_map"
/* MTD character device name */
#define VGM_MTD_CHAR_DEV_NAME   "/dev/mtdchar0"
/* MTD character device major number */
#define VGM_MTD_CHAR_DEV_MAJOR  90
/* The logical address to physical address conversion fixed number */
#define VGM_CHANGE_PADDR_VALUE  0x40000000


#define FEATURE_4K_NAND

#ifdef FEATURE_4K_NAND

/*********************************/
/* Define 4KByte PageSize FLASH  */
/*********************************/
#define VGM_NAND_BLOCK_SIZE    262144      /* byte per 1 block */
#define VGM_NAND_PAGE_SIZE     4096        /* byte per 1 page */
#define VGM_MAX_BAD_BLK        40          /* maximum number of bad block */
#define VGM_PAGES_IN_BLOCK     64          /* page per 1 block */
#define VGM_PAGE_MASK          0x00000FFF  /* page mask */
#define VGM_BLOCK_MASK         0x0003FFFF  /* block mask */
#define VGM_SPARE_BYTE_SIZE    160         /* SPARE BYTE size */
#define VGM_SPARE_USER_META    32          /* USER META DATA size in SPARE BYTE(Page Layout2) */

/* NAND size(512MByte) / VGM_NAND_BLOCK_SIZE(262144) = 2048 */
#define VGM_NAND_BLOCK_COUNT   2048    /* NAND memory maximum block number */

#elif defined(FEATURE_2K_NAND)

/*********************************/
/* Define 2KByte PageSize FLASH  */
/*********************************/
#define VGM_NAND_BLOCK_SIZE    131072      /* byte per 1 block */
#define VGM_NAND_PAGE_SIZE     2048        /* byte per 1 page */
#define VGM_MAX_BAD_BLK        80          /* maximum number of bad block */
#define VGM_PAGES_IN_BLOCK     64          /* page per 1 block */
#define VGM_PAGE_MASK          0x000007FF  /* page mask */
#define VGM_BLOCK_MASK         0x0001FFFF  /* block mask */
#define VGM_SPARE_BYTE_SIZE    64          /* SPARE BYTE size */
#define VGM_SPARE_USER_META    16          /* USER META DATA size in SPARE BYTE(Page Layout2) */

/* NAND size(512MByte) / VGM_NAND_BLOCK_SIZE(131072) = 4096 */
#define VGM_NAND_BLOCK_COUNT   4096    /* NAND memory maximum block number */

#endif /* FEATURE_4K_NAND */

/* Macro for conversion */
#define VGM_ADDR_TO_BID(addr)        ((dword)((addr) / VGM_NAND_BLOCK_SIZE))
#define VGM_ADDR_TO_PID(addr)        ((dword)((addr) / VGM_NAND_PAGE_SIZE))
#define VGM_BID_TO_ADDR(bid)         ((dword)((bid) * VGM_NAND_BLOCK_SIZE))
#define VGM_PID_TO_ADDR(pid)         ((dword)((pid) * VGM_NAND_PAGE_SIZE))

#define VGM_BID_TO_PID(bid)          ((bid) * VGM_PAGES_IN_BLOCK)
#define VGM_PID_TO_BID(pid)          ((int32) ((pid) / VGM_PAGES_IN_BLOCK))
#define VGM_PID_TO_BLOCK_OFFSET(pid) ((pid) % VGM_PAGES_IN_BLOCK)

/*===========================================================================

  Define start address and end address of the management domain to use in VGM.
  This define used when add spare block domain to vgm_mng_area declared 
  in vgm_area_map.c

===========================================================================*/
#define VGM_AREA_MIBIB_START          0x00140000U
#define VGM_AREA_MIBIB_END            0x0017FFFFU
#define VGM_AREA_TZ_START             0x00180000U
#define VGM_AREA_TZ_END               0x0023FFFFU
#define VGM_AREA_TZ_BK_START          0x00240000U
#define VGM_AREA_TZ_BK_END            0x002FFFFFU
#define VGM_AREA_RPM_START            0x00300000U
#define VGM_AREA_RPM_END              0x0033FFFFU
#define VGM_AREA_RPM_BK_START         0x00340000U
#define VGM_AREA_RPM_BK_END           0x0037FFFFU
#define VGM_AREA_APPSBL_START         0x00380000U
#define VGM_AREA_APPSBL_END           0x003FFFFFU
#define VGM_AREA_APPSBL_BK_START      0x00400000U
#define VGM_AREA_APPSBL_BK_END        0x0047FFFFU
#define VGM_AREA_RECOVERY_START       0x00480000U
#define VGM_AREA_RECOVERY_END         0x00C7FFFFU
#define VGM_AREA_RECOVERYFS_START     0x00C80000U
#define VGM_AREA_RECOVERYFS_END       0x0187FFFFU
#define VGM_AREA_RECFS_BK_START       0x01880000U
#define VGM_AREA_RECFS_BK_END         0x0247FFFFU
#define VGM_AREA_KC_META_START        0x02480000U
#define VGM_AREA_KC_META_END          0x024BFFFFU
#define VGM_AREA_KC_META_BK_START     0x024C0000U
#define VGM_AREA_KC_META_BK_END       0x024FFFFFU
#define VGM_AREA_APPS_START           0x02500000U
#define VGM_AREA_APPS_END             0x02CFFFFFU
#define VGM_AREA_NON_HLOS_START       0x02D00000U
#define VGM_AREA_NON_HLOS_END         0x051BFFFFU
#define VGM_AREA_SYSTEM_START         0x051C0000U
#define VGM_AREA_SYSTEM_END           0x077BFFFFU
#define VGM_AREA_ACDB_START           0x077C0000U
#define VGM_AREA_ACDB_END             0x07DBFFFFU
#define VGM_AREA_ACDB_META_START      0x07DC0000U
#define VGM_AREA_ACDB_META_END        0x07DFFFFFU
#define VGM_AREA_DN_APP_START         0x07E00000U
#define VGM_AREA_DN_APP_END           0x09BFFFFFU
#define VGM_AREA_DN_APP_META_START    0x09C00000U
#define VGM_AREA_DN_APP_META_END      0x09C3FFFFU

#define VGM_AREA_APP_DATA_START       0x0A6C0000U
#define VGM_AREA_APP_DATA_END         0x1ABBFFFFU
#define VGM_AREA_FOTA_MNG_START       0x1ABC0000U
#define VGM_AREA_FOTA_MNG_END         0x1AFBFFFFU

#define VGM_AREA_VGM_RO_START         0x09C40000U
#define VGM_AREA_VGM_APP_START        0x1AFC0000U

/* --------------------------------------------------------------------------
** Type Declarations
** --------------------------------------------------------------------------
*/
/* The definition of memory contents shared with an NAND driver. */
typedef struct
{
    dword   addr_map[VGM_NAND_BLOCK_COUNT];     /* address map      */
    dword   err_page_id;        /* error page address               */
    int32   result;             /* change result of VMT/address map */
    int32   valid;              /* valid flag of address map        */
} vgm_driver_share_mem_t;


/* define return value */
enum vgm_err_code
{
    VGM_BAD_BLOCK      =  1,    /* specify block address is bad                  */
    VGM_OK             =  0,    /* normal end                                    */
    VGM_FAIL           = -1,    /* error occurred with a flash device            */
    VGM_PAR_ERR        = -2,    /* parameter error                               */
    VGM_OVER_RANGE_ERR = -3,    /* VMT domain size too big(more than 1 block)    */
    VGM_NO_BLK_ERR     = -4,    /* the number of BadBlock exceeded a quota       */
    VGM_FATAL_ERR      = -5     /* fatal error                                   */
};

/*===========================================================================

  Define th ID of the management domain to use in VGM.
  This define added when add spare block domain to vgm_mng_area declared 
  in vgm_area_map.c

===========================================================================*/
typedef enum
{
//    VGM_MIN_AREA_NUM = -1, /* The minimum of the management domain */

    VGM_AREA_MIBIB,
    VGM_AREA_TZ,
    VGM_AREA_TZ_BK,
    VGM_AREA_RPM,
    VGM_AREA_RPM_BK,
    VGM_AREA_APPSBL,
    VGM_AREA_APPSBL_BK,
    VGM_AREA_RECOVERY,
    VGM_AREA_RECOVERYFS,
    VGM_AREA_RECFS_BK,
    VGM_AREA_KC_META,
    VGM_AREA_KC_META_BK,
    VGM_AREA_APPS,
    VGM_AREA_NON_HLOS,
    VGM_AREA_SYSTEM,
    VGM_AREA_ACDB,
    VGM_AREA_ACDB_META,
    VGM_AREA_DN_APP,
    VGM_AREA_DN_APP_META,
    VGM_AREA_APP_DATA,
    VGM_AREA_FOTA_MNG,

    VGM_MAX_AREA_NUM    /* The maximum of the management domain */
} vgm_area_type;

/* --------------------------------------------------------------------------
** Local Object Definitions
** --------------------------------------------------------------------------
*/

/* ==========================================================================
**                        Function Definitions
** ========================================================================*/

#endif /* VGM_H */
