/* security/kyocera/kclsm_sysfs.c  (kclsm LSM module sysfs interface)
 * This software is contributed or developed by KYOCERA Corporation.
 * (C) 2017 KYOCERA Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef KCLSM_SYSFS_H
#define KCLSM_SYSFS_H

#include <linux/list.h>

struct dna_apps {
	struct list_head list;
	pid_t pid;
};

struct dna_apps *find_stored_dna_app(pid_t pid);
bool is_target_path(const char* path);

/*
 * return true if dna is ready
 */
bool kclsm_sysfs_is_dna_ready(void);
#endif
