/*
 * This software is contributed or developed by KYOCERA Corporation.
 * (C) 2019 KYOCERA Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef __KCUSB_LOG_H_
#define __KCUSB_LOG_H_

#define TMPLOGMAX 256
extern void usb_log_write (const char *message, u32 length);
#define USBLOGOUT(fmt, ...)                                                       \
	{                                                                             \
		char tmpbuf[TMPLOGMAX];                                                   \
		int  kcusb_log_len;                                                       \
		do {                                                                      \
			kcusb_log_len = snprintf(&tmpbuf[0], TMPLOGMAX, fmt, ## __VA_ARGS__); \
			usb_log_write(&tmpbuf[0], kcusb_log_len);                             \
		} while (0);                                                              \
	}

#endif	/* __KCUSB_LOG_H_ */

