/*
 * This software is contributed or developed by KYOCERA Corporation.
 * (C) 2018 KYOCERA Corporation
 * (C) 2019 KYOCERA Corporation
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
/*===========================================================================*/


/*=============================================================================
**
**  Define data
**
=============================================================================*/
#include <asm/uaccess.h>    /* copy_from_user, copy_to_user */
#include <linux/errno.h>
#include <linux/fs.h>       /* inode, file, file_operations */
#include <linux/kernel.h>   /* printk */
#include <linux/module.h>
#include <soc/qcom/smem.h>

#include <smem/smem_dev.h>
MODULE_LICENSE("GPL");

static const char * const devnam = "smem";
static const int          devmaj = 191;

/*=============================================================================
**
**  Function
**
=============================================================================*/
static int chrdev_smem_open(struct inode* ino, struct file* fpt)
{
	return 0;
}

static int chrdev_smem_close(struct inode* ino, struct file* fpt)
{
	return 0;
}


static long chrdev_smem_ioctl(struct file* fpt, unsigned int cmd, unsigned long arg)
{
	smem_id_t  stk;
	void*      mpt = NULL;

    if((fpt->f_flags != (unsigned int)O_RDONLY) && (fpt->f_flags != (unsigned int)O_RDWR)){
        return -EINVAL;
    }
    if((unsigned long)0 != copy_from_user(&stk, (void*)arg, sizeof(stk))){ /* PRQA S:m3cm_A4_500_0041 306,483 */
        return -EBUSY;
    }
    if(stk.smem_id < SMEM_KCC_BASE){
        return -EINVAL;
    }
    if(stk.size <= (unsigned int)0){
        return -EINVAL;
    }

	switch(cmd){
		case (unsigned int)SMEM_CMD_READ:
			mpt = kc_smem_alloc((unsigned int)stk.smem_id, (unsigned int)stk.ofst + (unsigned int)stk.size);
			if(mpt == NULL){
				return -EBUSY;
			}else{
				if((unsigned long)0 == copy_to_user(stk.buff, mpt + stk.ofst, (unsigned int)stk.size)){ /* PRQA S:m3cm_A4_500_0041 306,483 */
					return 0;
				}else{
					return -EBUSY;
				}
			}
			break;
		case (unsigned int)SMEM_CMD_WRITE:
			if(fpt->f_flags == (unsigned int)O_RDONLY){
				return -EINVAL;
			}
			mpt = kc_smem_alloc((unsigned int)stk.smem_id, (unsigned int)stk.ofst + (unsigned int)stk.size);
			if(mpt == NULL){
				return -EBUSY;
			}else{
				if((unsigned long)0 == copy_from_user(mpt + stk.ofst, stk.buff, (unsigned int)stk.size)){ /* PRQA S:m3cm_A4_500_0041 306,483 */
					return 0;
				}else{
					return -EBUSY;
				}
			}
			break;
		default:
			return -ENOTTY;
			break;
	}
	return -EAGAIN;
}

static const struct file_operations devfop =
{
	.owner           = THIS_MODULE,
	.open            = chrdev_smem_open,
	.unlocked_ioctl  = chrdev_smem_ioctl,
	.release         = chrdev_smem_close,
};

static int __init chrdev_smem_start( void )
{
	if(register_chrdev(devmaj, devnam, &devfop)){
		return -1;
	}
	return 0;
}

static void __exit chrdev_smem_exit( void )
{
	unregister_chrdev(devmaj, devnam);
}

module_init(chrdev_smem_start);
module_exit(chrdev_smem_exit);
