/*
 *  conflict.h
 *
 *  This file is conflict controll driver's header file.
 *
 *  This software is contributed or developed by KYOCERA Corporation.
 *  (C) 2014 KYOCERA Corporation
 *  (C) 2015 KYOCERA Corporation
 *  (C) 2018-2021 KYOCERA Corporation
 *
 *  This file is subject to the terms and conditions of the GNU General Public
 *  License.  See the file COPYING in the main directory of this archive for
 *  more details.
 */

#ifndef CONFLICT_H
#define CONFLICT_H

/*******************************************************************************
 * CONSTANT / DEFINE DECLARATIONS
 ******************************************************************************/

/*----------------------------------------------------------------------------*/
/* DEFINE                                                                     */
/*----------------------------------------------------------------------------*/

#define CNFL_SMEM_ENABLE_CRC 1

#define CONFLICT_MAGIC  'c'
#define M_CONFLICT_TYPE_START _IOWR((uint8_t)CONFLICT_MAGIC, 0U, void *)
#define M_CONFLICT_TYPE_END   _IOWR((uint8_t)CONFLICT_MAGIC, 1U, void *)
#define M_CONFLICT_TYPE_GET   _IOWR((uint8_t)CONFLICT_MAGIC, 2U, void *)

#define CONF_TABLE_MNG_SIZE   4

#define EVENT_CNFL_MAX        65
#define AFT_STATE_TBL_MNG     0
#define AFT_STATE_TBL_STS     1

/*----------------------------------------------------------------------------*/
/* STRUCTURE                                                                  */
/*----------------------------------------------------------------------------*/

typedef struct {
	uint32_t     table[CONF_TABLE_MNG_SIZE];
} t_CONF_TABLE;

typedef struct {
	uint32_t     event_id;
	uint32_t     rc;
	t_CONF_TABLE table;
} conf_devctrl_s_type;

/*----------------------------------------------------------------------------*/
/* STATIC                                                                     */
/*----------------------------------------------------------------------------*/

static const
uint32_t competitiveManagementTable[EVENT_CNFL_MAX][CONF_TABLE_MNG_SIZE] = {
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* EVENT_CNFL_NONE */
    {0x00000001, 0x00000000, 0x00000000, 0x00000000},  /* EVENT_VOICE_CALL */
    {0x00000002, 0x00000000, 0x00000000, 0x00000000},  /* EVENT_SMS_TRANSMISSION */
    {0x00000004, 0x00000000, 0x00000000, 0x00000000},  /* EVENT_SMS_RECEPTION */
    {0x00000808, 0x00000000, 0x00000000, 0x00000000},  /* EVENT_DATA_DIALUP */
    {0x00000010, 0x00000000, 0x00000000, 0x00000000},  /* EVENT_PDN_CONN */
    {0x00000020, 0x00000000, 0x00000000, 0x00000000},  /* EVENT_PDN_CONN2 */
    {0x00000040, 0x00000000, 0x00000000, 0x00000000},  /* EVENT_DATA_USB_TETHER */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* EVENT_DATA_WIFI_LAN */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* EVENT_OTA_SMS_BIP */
    {0x00000200, 0x00000000, 0x00000000, 0x00000000},  /* EVENT_FOTA */
    {0x00000400, 0x00000000, 0x00000000, 0x00000000},  /* EVENT_GNSS */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* EVENT_PROHIBIT_DIALUP_ORIG */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
    {0x00000000, 0x00000000, 0x00000000, 0x00000000},  /* no use */
};

static const
uint32_t afterStateTable[EVENT_CNFL_MAX][2] = {
    { 0 , 0x00000000},  /* EVENT_CNFL_NONE */
    { 0 , 0x00000001},  /* EVENT_VOICE_CALL */
    { 0 , 0x00000002},  /* EVENT_SMS_TRANSMISSION */
    { 0 , 0x00000004},  /* EVENT_SMS_RECEPTION */
    { 0 , 0x00000008},  /* EVENT_DATA_DIALUP */
    { 0 , 0x00000010},  /* EVENT_PDN_CONN */
    { 0 , 0x00000020},  /* EVENT_PDN_CONN2 */
    { 0 , 0x00000040},  /* EVENT_DATA_USB_TETHER */
    { 0 , 0x00000000},  /* EVENT_DATA_WIFI_LAN */
    { 0 , 0x00000000},  /* EVENT_OTA_SMS_BIP */
    { 0 , 0x00000200},  /* EVENT_FOTA */
    { 0 , 0x00000400},  /* EVENT_GNSS */
    { 0 , 0x00000800},  /* EVENT_PROHIBIT_DIALUP_ORIG */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
    { 0 , 0x00000000},  /* no use */
};

#endif  /* CONFLICT_H */
