/*
 * This software is contributed or developed by KYOCERA Corporation.
 * (C) 2018 KYOCERA Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
#include <linux/module.h>
#include <linux/uaccess.h>
#include <linux/fs.h>
#include <linux/miscdevice.h>
#include <linux/kernel.h>
#include <linux/io.h>
#include <linux/errno.h>
#include <soc/qcom/smem.h>



static unsigned char val=0;

/* open */
static int kdiag_miscdef_open( struct inode *ip, struct file *fp)
{
    unsigned char *smem_ptr = NULL;
    smem_ptr = kc_smem_alloc( SMEM_KC_DIAG_MODE, KCC_SMEM_KC_DIAG_MODE_SIZE );
    if ( smem_ptr != NULL) {
        val = *smem_ptr;
    }
    return 0;
}

/* close */
static int kdiag_miscdef_close( struct inode *ip, struct file *fp)
{
    return 0;
}

/* read */
static ssize_t kdiag_miscdef_read( struct file *fp, char __user *buf,
                                size_t count, loff_t *f_pos )
{
    uint32_t ret;
    ssize_t read_size;
    unsigned char data[1];

    if( count != 1u )
    {
        printk(KERN_DEBUG "kdiag_misc: read -EINVAL\n");
        return -EINVAL;
    }

    if( buf == NULL )
    {
        printk(KERN_DEBUG "kdiag_misc: read -EFAULT\n");
        return -EFAULT;
    }
    data[0] = val;
    ret = copy_to_user( buf, data, 1u );
    if( ret != 0u )
    {
        return -EIO;
    }
    else
    {
       read_size = 1;
    }

    return read_size;
}

static const struct file_operations kdiag_miscdef_fops = {
    .owner   = THIS_MODULE,
    .open    = kdiag_miscdef_open,
    .read    = kdiag_miscdef_read,
    .release = kdiag_miscdef_close,
};

static struct miscdevice kdiag_miscdef_dev = {
    .minor = MISC_DYNAMIC_MINOR,
    .name  = "kdiag_miscdef",
    .fops  = &kdiag_miscdef_fops,
};

static __init int32_t kdiag_miscdef_init( void )
{

    return misc_register( &kdiag_miscdef_dev );
}

module_init( kdiag_miscdef_init );

MODULE_DESCRIPTION("KDIAG MISCDEF");
MODULE_LICENSE("GPL v2");
